;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/cee/cee-flock.el               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Nov 17 08:52:09 1998                          */
;*    Last change :  Tue Nov 24 17:06:10 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The CEE fontification.                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'cee-flock)
(require 'font-lock)

;*---------------------------------------------------------------------*/
;*    cee-font-lock-init ...                                           */
;*---------------------------------------------------------------------*/
(defun cee-font-lock-init ()
  (setq c-font-lock-keywords
	(list
	 (cons "//.*$"
	       'font-lock-comment-face)
	 (cons "^\\([*a-zA-Z0-9_:.]+[ ,\t]*\\)+"
	       'font-lock-function-name-face)
	 (cons (concat "\\("
		       "[a-zA-Z_.0-9]+::"
		       "\\|"
		       (concat "^#[\t ]*\\(define\\|include\\|if\\|endif"
			       "\\|else\\|undef\\|ifdef\\|ifndef\\)\\>")
		       "\\)")
	       'ude-font-lock-face-4)
	 (cons (concat "\\("
		       "[*&[]\\|\]"
		       "\\|"
		       "\\(\\<goto\\>[ \t]+[_a-zA-Z0-9]+\\|[a-zA-Z0-9_]+[ \t]*:\\)"
		       "\\)")
	       'ude-font-lock-face-2)
	 (list "<\\([^ \t\n>]+\\)>"
	       1
	       'font-lock-string-face)
	 (cons (concat "\\(\\<\\(for\\|case\\|do\\|while\\|switch\\|if\\|else"
		       "\\|return\\|continue\\|break\\|virtual"
		       "\\|new\\|malloc\\)\\>\\|[{}]\\)")
	       'font-lock-keyword-face)))
  (setq c-font-lock-keyword-1 '())
  (setq c-font-lock-keyword-2 '())
  (setq c-font-lock-keyword-3 '())

  (setq c++-font-lock-keywords
	(append c-font-lock-keywords
		(list
		 (cons "\\<\\(throws?\\|catch\\|try\\)\\>"
		       'ude-font-lock-face-3)
		 (cons "\\<\\(public\\|private\\|protected\\)\\>"
		       'ude-font-lock-face-4))))

  (setq c++-font-lock-keyword-1 '())
  (setq c++-font-lock-keyword-2 '())
  (setq c++-font-lock-keyword-3 '())

  (setq java-font-lock-keywords
	(append (list
		 (cons "\\<import\\>[ \t]+"
		       'ude-font-lock-face-5))
		c++-font-lock-keywords))

  (cond
   ((string= mode-name "C")
    (setq font-lock-keywords c-font-lock-keywords))
   ((string= mode-name "C++")
    (setq font-lock-keywords c++-font-lock-keywords))
   ((string= mode-name "Java")
    (setq font-lock-keywords java-font-lock-keywords))))

;*---------------------------------------------------------------------*/
;*    cee-font-lock-get-info-keywords ...                              */
;*    -------------------------------------------------------------    */
;*    The Cee font lock keyword list for xinfo.                        */
;*---------------------------------------------------------------------*/
(defun cee-font-lock-get-info-keywords ()
  (list (cons "^ - \\(?:Function\\|Variable\\): .*$"
	      'font-lock-function-name-face)))
