;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Engine/interp.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri May 31 08:03:39 1996                          */
;*    Last change :  Mon May 15 07:42:32 2000 (serrano)                */
;*    Copyright   :  1996-2000 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    The inner interpreter.                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module engine_interp
   (import engine_param)
   (export (interp version verbose file startup path args)))

;*---------------------------------------------------------------------*/
;*    interp ...                                                       */
;*---------------------------------------------------------------------*/
(define (interp version verbose files startup path args)
   (set! *bigloo-interpreter* #t)
   (if (and (>=fx verbose 0) (not (pair? files)))
       (begin
	  (version)
	  (print "Welcome to the interpreter")))
   ;; on definie la variable `(command-line)'
   (set! *the-command-line* (interp-parse-args args))
   ;; on charge le fichier de startup
   (if (string? startup)
       (let ((path (let ((home (getenv "HOME")))
		      (if (string? home)
			  (cons home path)
			  path))))
	  (let ((fstartup (find-file/path startup path)))
	     (if fstartup
		 (loadq startup)
		 (warning "interp"
			  #\Newline
			  "Can't file startup file -- " startup)))))
   ;; on rentre dans l'interprete
   (if (pair? files)
       (for-each loadq files)
       (repl))
   0)

;*---------------------------------------------------------------------*/
;*    interp-parse-args ...                                            */
;*---------------------------------------------------------------------*/
(define (interp-parse-args args)
   (let loop ((args (cdr args))
	      (res  '()))
      (cond
	 ((null? args)
	  (append *src-files* (reverse res)))
	 ((string=? (car args) "-i")
	  (loop (cdr args) res))
	 ((member (car args) *src-files*)
	  (loop (cdr args) res))
	 (else
	  (loop (cdr args) (cons (car args) res))))))
			   

