;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Expand/lambda.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec 28 15:44:53 1994                          */
;*    Last change :  Sat Jun 16 09:01:56 2001 (serrano)                */
;*    Copyright   :  1994-2001 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    The lambda macro-expansion.                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module expand_lambda
   (include "Tools/trace.sch")
   (import tools_args
	   tools_progn
	   tools_misc
	   tools_location
	   expand_eps
	   engine_param
	   (find-location tools_location))
   (export internal-definition?
	   (expand-lambda                      ::obj ::procedure)
	   (internal-begin-expander::procedure ::procedure)))

;*---------------------------------------------------------------------*/
;*    internal-definition? ...                                         */
;*---------------------------------------------------------------------*/
(define internal-definition? #f)

;*---------------------------------------------------------------------*/
;*    expand-lambda ...                                                */
;*---------------------------------------------------------------------*/
(define (expand-lambda x e)
   (let ((old-internal internal-definition?))
      (set! internal-definition? #t)
      (let ((res (match-case x
		    ((?lam ?args . (and ?body (not ())))
		     (with-lexical (args*->args-list args)
				   '_
				   (find-location x)
				   (lambda ()
				      (let ((e (internal-begin-expander e)))
					 `(,lam ,args
					     ,(e (normalize-progn body) e))))))
		    (else
		     (error #f "Illegal `lambda' form" x)))))
	 (set! internal-definition? old-internal)
	 (replace! x res))))
  
;*---------------------------------------------------------------------*/
;*    internal-begin-expander ...                                      */
;*---------------------------------------------------------------------*/
(define (internal-begin-expander old-expander)
   (lambda (expr expander)
      (let ((res (if (and (pair? expr) (eq? (car expr) 'begin))
		     (if (not (null? (cdr expr)))
			 (let ((rest (with-lexical
				      (begin-bindings (cdr expr))
				      '_
				      (find-location expr)
				      (lambda ()
					 (lambda-defines
					  (emap (lambda (x) (expander x expander))
						(cdr expr)))))))
			    (if (epair? expr)
				(econs 'begin rest (cer expr))
				(cons 'begin rest)))
			 #unspecified)
		     (old-expander expr expander))))
	 (if (pair? res)
	     (replace! expr res)
	     res))))

;*---------------------------------------------------------------------*/
;*    begin-bindings ...                                               */
;*---------------------------------------------------------------------*/
(define (begin-bindings body)
   (trace expand "let-bindings: " body
	  #\Newline)
   (let loop ((oldforms  body)
	      (vars     '()))
      (if (pair? oldforms)
	  (let ((form (car oldforms)))
	     (match-case form
		((define (?var . ?-) . ?-)
		 (loop (cdr oldforms)
		       (cons var vars)))
		((define ?var . ?-)
		 (loop (cdr oldforms)
		       (cons var vars)))
		(else
		 (loop (cdr oldforms)
		       vars))))
	  vars)))

;*---------------------------------------------------------------------*/
;*    lambda-defines ...                                               */
;*---------------------------------------------------------------------*/
(define (lambda-defines body)
   (trace expand "lambda-defines: " body
	  #\Newline)
   (let loop ((oldforms  body)
	      (newforms '())
	      (vars     '())
	      (decls    '()))
      (if (pair? oldforms)
	  (let ((form (car oldforms)))
	     (match-case form
		((define ?var ?val)
		 (loop (cdr oldforms)
		       newforms
		       (cons var vars)
		       (cons `(,var ,val)
			     decls)))
		(else
		 (loop (cdr oldforms)
		       (cons form newforms)
		       vars
		       decls))))
	  (cond
	     ((not (null? vars))
	      (let ((nf (if (null? newforms)
			    #unspecified
			    (normalize-progn (reverse newforms)))))
		 `((letrec ,decls ,nf))))
	     (else
	      body)))))
