;*=====================================================================*/
;*    serrano/prgm/project/bigloo2.3/comptime/Expand/syntax.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec 28 14:56:58 1994                          */
;*    Last change :  Sun Oct  1 14:31:30 2000 (serrano)                */
;*    Copyright   :  1994-2000 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    The r5rs syntax expansion.                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_syntax-case
   (include "Tools/trace.sch"
	    "Engine/pass.sch"
	    "Ast/unit.sch")
   (import  tools_speek
	    tools_error)
   (export  (syntax-expand-units ::obj)))

;*---------------------------------------------------------------------*/
;*    syntax-expand-units ...                                          */
;*    -------------------------------------------------------------    */
;*    We expand the user code and the produced codes.                  */
;*---------------------------------------------------------------------*/
(define (syntax-expand-units units)
   (pass-prelude "Syntax")
   (define handler (lambda (escape proc mes obj)
		      (user-error proc mes obj ''())))
   ;; we scan all units
   (for-each (lambda (unit)
		(if (procedure? (unit-sexp* unit))
		    ;; a freezed unit (such as the eval unit)
		    ;; cannot be macro expanser.
		    'nothing
		    (let loop ((src (unit-sexp* unit))
			       (res '()))
		       (if (null? src)
			   (unit-sexp*-set! unit (reverse! res))
			   (let ((new-body (try (expand-syntax (car src))
						handler)))
			      (loop (cdr src) (cons new-body res)))))))
	     units)
   (pass-postlude units))
      
