(module jas_lib
   (export (u2 ::int)
	   (u4 ::int)
	   (w2 ::int)
	   (w4 ::long)
	   (f2 ::float)
	   (f4 ::double) ))

;; Simple but useful
(define (u2 n::int)
   (list (bit-and (bit-rsh n 8) #xFF)
	 (bit-and n #xFF) ))
   
(define (u4 n::int)
   (list (bit-and (bit-rsh n 24) #xFF)
	 (bit-and (bit-rsh n 16) #xFF)
	 (bit-and (bit-rsh n 8) #xFF)
	 (bit-and n #xFF) ))

(define (w2 n::int)
   (list (bit-and (bit-rsh n 16) #xFFFF)
	 (bit-and n #xFFFF) ))

(define (w4 n::long)
   ;; CARE (bit-rsh 2 32) = 2
   (list (bit-and (bit-rsh (bit-rsh (bit-rsh n 16) 16) 16) #xFFFF)
	 (bit-and (bit-rsh (bit-rsh n 16) 16) #xFFFF)
	 (bit-and (bit-rsh n 16) #xFFFF)
	 (bit-and n #xFFFF) ))

(define (f2 n::float)
   (string->shortlist (float->ieee-string n)) )

(define (f4 n::double)
   (string->shortlist (double->ieee-string n)) )

(define (string->shortlist s)
   (let ( (n (string-length s)) )
      (define (collect i)
	 (if (=fx i n)
	     '()
	     (cons (bit-or (bit-lsh (char->integer (string-ref s i)) 8)
			   (char->integer (string-ref s (+fx i 1))) )
		   (collect (+fx i 2)) )))
      (collect 0) ))
