;*=====================================================================*/
;*    serrano/prgm/project/bigloo/recette/rgc.scm                      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Sep  8 11:03:03 1994                          */
;*    Last change :  Tue Nov  9 10:12:42 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Quelques tests d'rgc                                             */
;*=====================================================================*/


;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module rgc
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-rgc)))

;; cette grammaire plante tous les bigloo (a la compilation)
;; jusqu'a la version 1.6c
(regular-grammar
      ((sign (in #\+ #\-))
       (optsign (>= 1 sign))
       (octdigit (in ("07"))))
   ((: #\0 optsign octdigit)
    0))

(regular-grammar ()
   ((: #\a (? #\b) #\c)
    0))

(regular-grammar ()
   ((: (? #\a) #\b #\c)
    0))

(regular-grammar ()
   ((: #\a #\b (? #\c))
    0))

;; une grammaire qui ne se compilait pas lors du permier boot de bigloo1.8
(define *std-grammar*
   (regular-grammar ((chiffre (in ("09")))
		     (lettre  (in ("azAZ") #a128 #a255))
		     (special (in "!@~$%^&*></.-_+\|=?:"))
		     (id      (: (or lettre chiffre special)
				 (* (or lettre chiffre special #\, #\' #\`)))))
      ((: #\# #\a chiffre chiffre chiffre)
       ;; character ascii forms
       0)
      ((: ";" (* all))
       ;; commets
       (ignore))
      ((: #\# (or id (: #\. (+ #\.))) #\()
       ;; typed vectors beginning
       1)
      (else
       2)))

(define *number*
   (regular-grammar ()
      ((: (submatch (+ digit)) "." (submatch (+ digit)))
       (cons (string->integer (the-submatch 1))
	     (string->integer (the-submatch 2))))))

(define *number2*
   (regular-grammar ()
      ((: (submatch (* digit)) "." (submatch (* digit)))
       (cons (string->integer (the-submatch 1))
	     (string->integer (the-submatch 2))))))

(define (recette-suffix string)
   (string-case string
      ((: (* all) "." (submatch (+ (out "."))))
       (the-submatch 1))
      (else
       "")))

(define (test-rgc= str)
   (let ((port (open-input-string str))
	 (gram (regular-grammar ()
             ((= 2 (: #\; (* all) #\newline))
	      (the-string))
	     (else
	      ""))))
      (read/rp gram port)))

(define (test-rgc>= str)
   (let ((port (open-input-string str))
	 (gram (regular-grammar ()
             ((>= 2 (: #\; (* all) #\newline))
	      (the-string))
	     (else
	      ""))))
      (read/rp gram port)))

(define (rgc-and str)
   (let ((port (open-input-string str))
	 (gram (regular-grammar ()
		  ((+ (and (#\a #\b) "09abcd")) (the-string))
		  (else
		   ""))))
      (read/rp gram port)))

(define (rgc-and-2 str)
   (let ((port (open-input-string str))
	 (gram (regular-grammar ()
		  ((+ (and "am" "nz")) (the-string))
		  (else
		   ""))))
      (read/rp gram port)))

(define (rgc-but str)
   (let ((port (open-input-string str))
	 (gram (regular-grammar ()
		  ((+ (but ("09ad") ("ce"))) (the-string))
		  (else
		   ""))))
      (read/rp gram port)))

(define (rgc-** str)
   (let ((port (open-input-string str))
	 (gram (regular-grammar ()
		  ((** 3 6 #\a) (the-string)))))
      (read/rp gram port)))

(define (rgc-... str)
   (let ((port (open-input-string str))
	 (gram (regular-grammar ()
		  ((... 3 "begin") (the-string)))))
      (read/rp gram port)))

(define (rgc-submatch str)
   (let ((port (open-input-string str))
	 (gram (regular-grammar ()
		  ((: (submatch (* #\space))
		      (submatch (+ #\+))
		      (submatch (* #\space)))
		   (string-append (the-submatch 1) (the-submatch 3))))))
      (read/rp gram port)))
   
;*---------------------------------------------------------------------*/
;*    test-rgc ...                                                     */
;*---------------------------------------------------------------------*/
(define (test-rgc)
   (test-module "rgc" "rgc.scm")
   (test "submatch+" 
	 (read/rp *number* (open-input-string "3.1415"))
	 '(3 . 1415))
   (test "submatch*"
	 (read/rp *number2* (open-input-string "3.1415"))
	 '(3 . 1415))
   (test "string-case" (recette-suffix "toto.org.scm") "scm")
   (test "rgc ="
	 (test-rgc= #";1line\n;2line\n;3line\n;4line\n")
	 #";1line\n;2line\n")
   (let ((str #";1line\n;2line\n;3line\n;4line\n"))
      (test "rgc >="
	    (test-rgc>= str)
	    str))
   (test "rgc and" (rgc-and "aaaabbbbccc") "aaaabbbb")
   (test "rgc and" (rgc-and-2 "aaaabbbbccc") "")
   (test "rgc but" (rgc-but "aaaabbbbccc") "aaaabbbb")
   (test "rgc **" (rgc-** "aaaaaaaaaaabbbbccc") "aaaaaa")
   (test "rgc ..." (rgc-... "begin") "beg")
   (test "rgc submatch" (rgc-submatch "   +++   ") "      ")
   (test "fixnum" ((regular-grammar () ((: digit) (the-fixnum)))
		   (open-input-string "1234"))
	 1)
   (test "fixnum" ((regular-grammar () ((+ digit) (the-fixnum)))
		   (open-input-string "1234"))
	 1234))
