/*=====================================================================*/
/*    serrano/prgm/project/bigloo2.3/runtime/Clib/cstruct.c            */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Jun 16 09:28:53 1992                          */
/*    Last change :  Fri Aug 25 10:22:44 2000 (serrano)                */
/*    Copyright   :  2000 Manuel Serrano                               */
/*    -------------------------------------------------------------    */
/*    Structures constructions.                                        */
/*=====================================================================*/
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    set_struct ...                                                   */
/*---------------------------------------------------------------------*/
obj_t
set_struct( obj_t heap, obj_t key, int len )
{
   obj_t structure = (obj_t)heap;
   
#if( !defined( TAG_STRUCTURE ) )
   structure->struct_t.header = MAKE_HEADER( STRUCT_TYPE, byte_size );
#endif	

   structure->struct_t.key    = key;
   structure->struct_t.length = len;
   
   return BGL_HEAP_DEBUG_MARK_OBJ( BSTRUCTURE( structure ) );
}
   
/*---------------------------------------------------------------------*/
/*    create_struct ...                                                */
/*---------------------------------------------------------------------*/
obj_t
create_struct( obj_t key, int len )
{
   int  byte_size = STRUCT_SIZE + ( (len-1) * OBJ_SIZE );
   
   return set_struct( (obj_t)GC_MALLOC( byte_size ), key, len );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    fill_struct ...                                                  */
/*---------------------------------------------------------------------*/
obj_t
fill_struct( obj_t structure, int len, obj_t init )
{
   int i;
   
   for( i = 0; i < len; i++ )
      STRUCT_SET( structure, i, init );

   return structure;
}

/*---------------------------------------------------------------------*/
/*    make_struct ...                                                  */
/*---------------------------------------------------------------------*/
obj_t
make_struct( obj_t key, int len, obj_t init )
{
   obj_t structure;

   structure = create_struct( key, len );
   fill_struct( structure, len, init );
   
   return structure;
}

