/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Jlib/flusher.java            */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Dec  8 17:13:14 2000                          */
/*    Last change :  Fri Jul  6 15:14:40 2001 (serrano)                */
/*    Copyright   :  2000-01 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    A simple class that implements object that flush two output      */
/*    ports.                                                           */
/*=====================================================================*/
package bigloo;
import java.lang.Runnable;
import java.io.*;
import java.lang.Thread;

/*---------------------------------------------------------------------*/
/*    FLUSHER ...                                                      */
/*---------------------------------------------------------------------*/
class flusher {
    Thread flush_err, flush_out;

    flusher( Process proc ) {
	this( proc.getInputStream(), proc.getErrorStream() );
    }

    flusher( final InputStream out, final InputStream err ) {
	// prepare the thread for flushing out the process stderr stream
	if( err != null ) {
	    flush_err = new Thread( new Runnable () {
		    int len;
		    byte[] buf = new byte[ 1024 ];
		    public void run() {
			try {
			    while( (len=err.read( buf ) ) == 1024 ) {
				System.err.write( buf );
			    }
			    if( len > 0 )
				System.err.write( buf, 0, len );
			}
			catch( IOException e ) { ; }
		    }
		});
	} else {
	    flush_err = null;
	}

	// prepare the thread for flushing out the process stdout stream
	if( out != null ) {
	    flush_out = new Thread( new Runnable() {
		    int len;
		    byte[] buf = new byte[ 1024 ];
		    public void run() {
			try {
			    while( (len=out.read( buf )) == 1024 ) {
				System.out.write( buf );
			    }
			    if( len > 0 )
				System.out.write( buf, 0, len );
			}
			catch( IOException e ) { ; }
		    }
		});

	} else {
	    flush_out = null;
	}
    }

    public void flush() {
	// flush the pending outputs
	if( flush_out != null ) 
	    flush_out.start();
	if( flush_err != null ) 
	    flush_err.start();
    }
}

	
