package bigloo;

import java.io.*;

public abstract class input_port extends obj {
    // public Object kindof;
    public String name;
    public long filepos = 0;
    public int bufsiz;
    public boolean eof = false;
    public boolean other_eof = false;
    public int matchstart = 0;
    public int matchstop = 0;
    public int forward = 0;
    public byte lastchar = (byte) '\n';
    public int abufsiz = 1;
    public byte[] buffer;
    
    public input_port() {
    }

    public input_port(String name, int bufsiz) {
	this.name = name;
	this.bufsiz = bufsiz;
	buffer = new byte[bufsiz];
    }


    public abstract void close() throws IOException;

    public abstract boolean rgc_charready();

    public boolean reset_eof() {
	return(false);
    }

    public abstract boolean rgc_fill_buffer() throws IOException;

    final void rgc_enlarge_buffer() {
	int bufsize = this.bufsiz;
	byte[] obuffer = buffer;
	byte[] nbuffer = new byte[2 * bufsize];
	for(int i=0; i<bufsize; i++) nbuffer[i] = obuffer[i];
	this.bufsiz = 2 * bufsize;
	buffer = nbuffer;
    }

    Object bgl_input_port_seek(long pos)  throws IOException {
	return(bigloo.foreign.BFALSE);
    }

    Object bgl_input_port_reopen()  throws IOException {
	return(bigloo.foreign.BFALSE);
    }

    public void write(output_port p) {
	p.write("[PORT " + name + " @" + filepos + "-" + matchstart + "." + forward + "." + matchstop + "-" + bufsiz + "." + abufsiz + "]");
    }
}
