(module dotnet_constr
   (import type_type ast_var ast_node
	   module_module   ; *module*
	   object_class     ; tclass
           dotnet_extern dotnet_env dotnet_instr )
   (export (dotnet-constructors env::env me::symbol super::symbol)) )

;;
;; Construct all the JVM <*init> methods (known as constructors)
;;
(define (dotnet-constructors env::env me::symbol super::symbol)
   (list (constr env me super '())
	 (constr env me super '(int int))
	 (constr env me super '(int int int))
	 (clinit env me) ))

;;
;; All <init>s
;;
(define (constr env me super args)
   (define (name s l)
      (string->symbol (string-append s (integer->string (length l)))) )
   (let ( (init (name "init" args)) (sinit (name "sinit" args)) )
      (env-declare env init `(method ,me (public) void "<init>" ,@args))
      (env-declare env sinit `(method ,super (public) void "<init>" ,@args))
      (let ( (params (map (lambda (t) (gensym "A")) args)) )
	 `(method ,init (this ,@params) ()
		  (aload this)
		  ,@(map (lambda (p) `(iload ,p)) params)
		  (invokespecial ,sinit)
		  (return) ))))

;;
;; the <clinit> method
;;
(define (clinit env me)
   (env-declare env 'clinit `(method ,me (public static) void "<clinit>"))
   `(method clinit () ()
	    (ldc ,(symbol->string *module*))
	    (putstatic __the_module_name__)
	    ,@(reverse! (env-clinit-code env))
	    (return) ))
   
   
