;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bde/bmem/example/example.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr 24 09:10:43 2003                          */
;*    Last change :  Thu Apr 24 09:41:50 2003 (serrano)                */
;*    Copyright   :  2003 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    The test                                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module example
   (main main)
   (import number))

;*---------------------------------------------------------------------*/
;*    integer->nb ...                                                  */
;*---------------------------------------------------------------------*/
(define (integer->nb value::int)
   (instantiate::Integer
      (value value)))

;*---------------------------------------------------------------------*/
;*    real->nb ...                                                     */
;*---------------------------------------------------------------------*/
(define (real->nb value::real)
   (instantiate::Real
      (value value)))

;*---------------------------------------------------------------------*/
;*    fib ...                                                          */
;*---------------------------------------------------------------------*/
(define (fib::nb x::nb)
   (if (<nb x (integer->nb 2))
       (real->nb (exact->inexact 1))
       (+nb (fib (-nb x (integer->nb 1))) (fib (-nb x (integer->nb 2))))))

;*---------------------------------------------------------------------*/
;*    fact                                                             */
;*---------------------------------------------------------------------*/
(define (fact::nb x::nb)
   (if (<nb x (integer->nb 2))
       (real->nb (exact->inexact 1))
       (*nb x (fact (-nb x (integer->nb 1))))))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (let ((fibnum (if (pair? (cdr argv))
		     (string->integer (cadr argv))
		     20))
	 (factnum (if (pair? (cddr argv))
		      (string->integer (caddr argv))
		      10)))
      (printf "fib(~a)=~a~nfact(~a)=~a~n"
	      fibnum (fib (integer->nb fibnum))
	      factnum (fib (integer->nb factnum)))))
