// (c) 2005 Martin Aumueller <aumuell@reserv.at>
// See COPYING file for licensing information

#include "resolver.h"
#include "mp4file.h"

#include <src/audio_typefind.hh>

TagLib::File *MP4FileTypeResolver::createFile (const char*                        filename,
                                               bool                               read_properties,
                                               TagLib::AudioProperties::ReadStyle properties_style) const
{
    std::string type;

    if (!Bmp::Audio::typefind (filename, type))
      return 0;

    if (type == "audio/x-m4a")
      return new TagLib::MP4::File (filename, read_properties, properties_style);

    return 0;
}
