//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#include <gtkmm.h>
#include <glibmm/i18n.h>
#include <libglademm.h>

#include "ui_toolbox.hh"
#include "x_play.hh"
#include "x_vfs.hh"

#include "main.hh"
#include "paths.hh"
#include "dialog-export.hh"

namespace Bmp
{
      ExportDialog*
      ExportDialog::create ()
      {
        const std::string path = Glib::build_filename (BMP_GLADE_DIR, "dialog-export.glade");
        Glib::RefPtr<Gnome::Glade::Xml> xml = Gnome::Glade::Xml::create (path);
        ExportDialog *p = 0;
        xml->get_widget_derived ("export_dialog", p);
        return p;
      }

      ExportDialog::ExportDialog (BaseObjectType *cobject,
                                  const Glib::RefPtr<Gnome::Glade::Xml> &xml)
            : Gtk::Dialog (cobject),
              m_ref_xml (xml)
      {
        using namespace Gtk;
        using namespace Glib;
        using namespace std;

        m_ref_xml->get_widget ("view_plugins",
                  view_plugins);

        m_ref_xml->get_widget ("entry_filename",
                  entry_filename);

        m_ref_xml->get_widget ("button_browse",
                      button_browse);

        m_ref_xml->get_widget ("all",
                  all);

        m_ref_xml->get_widget ("filebrowser",
                  filebrowser);
    
        Util::window_set_icon_list (GTK_WIDGET (gobj()), "player");


        Gtk::CellRendererText *cell = Gtk::manage ( new Gtk::CellRendererText() );
        view_plugins->append_column (_("Export As..."), *cell);
        Gtk::TreeViewColumn *column  = view_plugins->get_column (0);
        column->add_attribute (*cell, "text", 0);

        store_plugins = Gtk::ListStore::create (columns);

        Bmp::VFS::ExportDataList containers;
        vfs->get_containers (containers);

        for (Bmp::VFS::ExportDataList::const_iterator container  = containers.begin ();
                                                      container != containers.end (); container++)
          {
            TreeModel::iterator i = store_plugins->append ();
            (*i)[columns.desc] = container->description;
            (*i)[columns.extension] = container->extension;
          }

        view_plugins->set_model (store_plugins);
        view_plugins->signal_cursor_changed().connect (sigc::mem_fun (*this, &Bmp::ExportDialog::cursor_changed));
        button_browse->signal_clicked().connect (sigc::mem_fun (*this, &Bmp::ExportDialog::select_path));
        all->signal_toggled().connect (sigc::mem_fun (*this, &Bmp::ExportDialog::all_toggled));

        all_files = all->get_active ();

        TreeModel::iterator first = store_plugins->children().begin();  
        view_plugins->get_selection()->select (first);
        string extension = (*first)[columns.extension];
        string listname  = build_filename (get_home_dir (), "Playlist." + extension);
        entry_filename->set_text (listname);
     }

      void
      ExportDialog::all_toggled ()
      {
        all_files = (all->get_active());
      }

      void
      ExportDialog::cursor_changed ()
      {
        using namespace Gtk;
        using namespace Glib;
        using namespace std;

        ustring name;

        ustring text = entry_filename->get_text ();

        string::size_type position = text.rfind (".");

        if (position != string::npos)
          {
            name = text.substr (0, position+1);
          }
        else
          {
            name = text;
          }

        TreeModel::iterator selected = view_plugins->get_selection()->get_selected (); 
        string extension = (*selected)[columns.extension];
        ustring composited;
        if (position != string::npos)
          {
            composited = name + extension;
          } 
        else
          {
            composited = name + "." + extension;
          }
    
        entry_filename->set_text (composited);
        container = (*selected)[columns.extension];
      }

      void
      ExportDialog::select_path ()
      {
        using namespace Glib;
        using namespace Gtk;
        using namespace std;

        ustring filename = entry_filename->get_text ();
        if (!filename.empty ())
        {
          string basename = Glib::path_get_basename (filename);
          string dirname = Glib::path_get_dirname (filename);
          
          filebrowser->set_current_folder (dirname);
          filebrowser->set_current_name (basename);
        }

        int response = filebrowser->run ();

        switch (response)
        {
            case Gtk::RESPONSE_CANCEL: break;
            case Gtk::RESPONSE_OK:
              {
                entry_filename->set_text (filebrowser->get_filename());     
                break;
              }
        }
        filebrowser->hide ();
      }
}
