//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_DIALOG_EXPORT_HH 
#define BMP_DIALOG_EXPORT_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glibmm.h>
#include <glibmm/markup.h>
#include <gtkmm.h>
#include <libglademm.h>

namespace Bmp
{
    class ExportDialog : public Gtk::Dialog
    {
      public:
        ExportDialog (BaseObjectType                       *cobject,
                      const Glib::RefPtr<Gnome::Glade::Xml> &xml);
        ~ExportDialog () {}
        static ExportDialog* create ();

        std::string  container;
        Gtk::Entry  *entry_filename;      
        bool	       all_files;

      private:

        void cursor_changed ();
        void select_path ();
        void all_toggled ();

        class PluginsColumnRecord : public Gtk::TreeModelColumnRecord
        { 
          public:
            Gtk::TreeModelColumn<Glib::ustring> desc;
            Gtk::TreeModelColumn<std::string>   extension;

            PluginsColumnRecord ()
            {
              add (desc);
              add (extension);
            }
        };
        PluginsColumnRecord columns;

        // GladeXML Data
        Glib::RefPtr<Gnome::Glade::Xml>     m_ref_xml;
        Glib::RefPtr<Gtk::ListStore>	      store_plugins;
        Gtk::TreeView			                 *view_plugins;
        Gtk::Button			                   *button_browse;
        Gtk::RadioButton		               *all;
        Gtk::FileChooserDialog	           *filebrowser;
    };
}
#endif // !BMP_DIALOG_EXPORT_HH
