//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2006 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non GPL-compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#ifndef BMP_FILESYSTEM_TREE_HH
#define BMP_FILESYSTEM_TREE_HH

#include <iostream>
#include <gtkmm.h>
#include <glibmm.h>
#include <gdkmm.h>
#include <pangomm.h>
#include <libglademm.h>

#include "util.hh"
#include "vfs.hh"

namespace Bmp
{
  class FilesystemTree : public Gtk::TreeView
  {
      public:

#include "exception.hh"

    EXCEPTION(ErrorPathDoesNotExist)
    EXCEPTION(ErrorPathIsNotDirectory)
    EXCEPTION(ErrorPathIsEmpty)

        typedef sigc::signal<void> OnPathActivated;

        FilesystemTree (BaseObjectType                       * obj,
            Glib::RefPtr<Gnome::Glade::Xml> const& xml);
        ~FilesystemTree ();

        void set_root (std::string const& path);
        void get_selected_uris (Bmp::VUri & uris);

        OnPathActivated&
        on_path_activated () { return on_path_activated_; }

      protected:
      
        virtual bool on_test_expand_row (Gtk::TreeModel::iterator const& iter, Gtk::TreeModel::Path const& path);
        virtual void on_row_activated (Gtk::TreeModel::Path const& path, Gtk::TreeViewColumn * column);

      private:

        OnPathActivated on_path_activated_;

        typedef std::vector<std::string> TPathList;

        void cell_data_func_node_icon (Gtk::CellRenderer * cell, Gtk::TreeModel::iterator const& m_iter);
        void append_placeholder (Gtk::TreeModel::iterator const& i_node);
        void append_child_nodes (Gtk::TreeModel::iterator const& i_root, std::string const& path,
                                  TPathList const& dir);

        enum NodeType
        {
          NODE_PATH,
          NODE_FILE,
          NODE_PLACEHOLDER,
        };

        class Nodes : public Gtk::TreeModel::ColumnRecord
        {
          public:

            Gtk::TreeModelColumn<Glib::ustring> name; 
            Gtk::TreeModelColumn<std::string>   path; 
            Gtk::TreeModelColumn<NodeType>      type; 
            Gtk::TreeModelColumn<bool>          children;
            Gtk::TreeModelColumn<bool>          xpanded;

            Nodes ()
            {
              add (name);
              add (path);
              add (type);
              add (children);
              add (xpanded);
            }
        };

        Nodes node;

        Glib::RefPtr<Gtk::TreeStore> store;
        Glib::RefPtr<Gdk::Pixbuf> m_icon_path;
        Glib::RefPtr<Gdk::Pixbuf> m_icon_file;

        StrV m_containers;
  };
}

#endif //!BMP_FILESYSTEM_TREE_HH

