//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <iostream>
#include <cstring>
#include <cstdlib>
#include <gtkmm.h>

#include <dbus/dbus-glib.h>
#include <dbus/dbus-shared.h>

#include <dbus-gaim.h>
#include "gaim-dbus.hh"

namespace Bmp
{
  namespace Gaim
  {
    void
    DBUS::NameOwnerChanged (DBusGProxy *proxy, char *name, char *old_owner, char *new_owner, gpointer data)
    {
      using namespace std;
      Bmp::Gaim::DBUS *gaimdbus = reinterpret_cast<Bmp::Gaim::DBUS *>(data);

      if (string(name) != string(DBUS_SERVICE_GAIM)) return;

      if ((std::strlen(new_owner)>0))
      {
        GError *error = 0;
        gaimdbus->gaim = dbus_g_proxy_new_for_name_owner (gaimdbus->bus,
                                                DBUS_SERVICE_GAIM,
                                                DBUS_PATH_GAIM,
                                                DBUS_INTERFACE_GAIM,
                                                &error);
        gaimdbus->s_gaim_present_.emit();
        return;
      }

      if ((std::strlen(new_owner)==0)) 
      {
        if (gaimdbus->gaim) g_object_unref (gaimdbus->gaim);
        gaimdbus->gaim = 0;
        gaimdbus->s_gaim_lost_.emit();
        return;
      }
    }

    bool
    DBUS::gaim_is_present () const
    {
      return (gaim ? true:false);
    }

    DBUS::DBUS () : bus (0), gaim (0), fdobus (0)
    {
        GError *error = 0;

        bus = dbus_g_bus_get (DBUS_BUS_SESSION, &error); 
        if (error)
        {
            throw ConnectionError (error->message);
        }

        fdobus = dbus_g_proxy_new_for_name_owner (bus,
                                                  DBUS_SERVICE_DBUS,
                                                  DBUS_PATH_DBUS,
                                                  DBUS_INTERFACE_DBUS,
                                                  &error);

        dbus_g_proxy_add_signal (fdobus, "NameOwnerChanged",
            G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INVALID);
        dbus_g_proxy_connect_signal (fdobus, "NameOwnerChanged",
            G_CALLBACK (Bmp::Gaim::DBUS::NameOwnerChanged), this, NULL);

        gaim = dbus_g_proxy_new_for_name_owner
                  (bus,
                   DBUS_SERVICE_GAIM,
                   DBUS_PATH_GAIM,
                   DBUS_INTERFACE_GAIM,
                   &error);

        if (error || !gaim) return;
        if (gaim) s_gaim_present_.emit();
    }

    DBUS::~DBUS ()
    {
      if (gaim) g_object_unref (gaim);
      if (fdobus) g_object_unref (fdobus);
      dbus_g_connection_unref (bus);
    }

    void
    DBUS::get_online_buddies (DBUS::OnlineBuddies & buddies)
    {
      GError *error = 0;
      int node;

      if (!dbus_g_proxy_call (gaim, "GaimBlistGetRoot",
                              &error,
                              G_TYPE_INVALID,
                              G_TYPE_INT,
                              &node,
                              G_TYPE_INVALID))
        {
          throw GaimDbusError (error->message);
        }

      while (node)
        {
          GError *error = 0;
          Buddy buddy;

          int is_buddy = 0;
          if (!dbus_g_proxy_call (gaim, "GaimBlistNodeIsBuddy",
                                &error,
                                G_TYPE_INT,
                                node,
                                G_TYPE_INVALID,
                                G_TYPE_INT,
                                &is_buddy,
                                G_TYPE_INVALID))
            {
              throw GaimDbusError (error->message);
            }

          if (is_buddy)
            {
                // Is online? 
                int online = 0;
                if (!dbus_g_proxy_call (gaim, "GaimBuddyIsOnline",
                                      &error,
                                      G_TYPE_INT,
                                      node,
                                      G_TYPE_INVALID,
                                      G_TYPE_INT,
                                      &online,
                                      G_TYPE_INVALID))
                  {
                    throw GaimDbusError (error->message);
                  }

                if (online)
                  {
                    char    *name           = 0,
                            *alias          = 0,
                            *protocol_name  = 0,
                            *protocol_id    = 0;

                    int      account        = 0,
                             connection     = 0,
                             icon           = 0,
                             contact        = 0;

                    // Contact 
                    if (!dbus_g_proxy_call (gaim, "GaimBuddyGetContact",
                                          &error,
                                          G_TYPE_INT,
                                          node,
                                          G_TYPE_INVALID,
                                          G_TYPE_INT,
                                          &contact,
                                          G_TYPE_INVALID))
                      {
                        throw GaimDbusError (error->message);
                      }


                    // Name 
                    if (!dbus_g_proxy_call (gaim, "GaimBuddyGetName",
                                          &error,
                                          G_TYPE_INT,
                                          node,
                                          G_TYPE_INVALID,
                                          G_TYPE_STRING,
                                          &name,
                                          G_TYPE_INVALID))
                      {
                        throw GaimDbusError (error->message);
                      }

                    // ContactAlias 
                    if (!dbus_g_proxy_call (gaim, "GaimContactGetAlias",
                                          &error,
                                          G_TYPE_INT,
                                          contact,
                                          G_TYPE_INVALID,
                                          G_TYPE_STRING,
                                          &alias,
                                          G_TYPE_INVALID))
                      {
                        throw GaimDbusError (error->message);
                      }

                    // Get buddy account
                    if (!dbus_g_proxy_call (gaim, "GaimBuddyGetAccount",
                                          &error,
                                          G_TYPE_INT,
                                          node,
                                          G_TYPE_INVALID,
                                          G_TYPE_INT,
                                          &account,
                                          G_TYPE_INVALID))
                      {
                        throw GaimDbusError (error->message);
                      }

                    // Get icon
                    if (!dbus_g_proxy_call (gaim, "GaimBuddyGetIcon",
                                          &error,
                                          G_TYPE_INT,
                                          node,
                                          G_TYPE_INVALID,
                                          G_TYPE_INT,
                                          &icon,
                                          G_TYPE_INVALID))
                      {
                        throw GaimDbusError (error->message);
                      }


                    // Get connection 
                    if (!dbus_g_proxy_call (gaim, "GaimAccountGetConnection",
                                          &error,
                                          G_TYPE_INT,
                                          account,
                                          G_TYPE_INVALID,
                                          G_TYPE_INT,
                                          &connection,
                                          G_TYPE_INVALID))
                      {
                        throw GaimDbusError (error->message);
                      }

                    // Get protocol id 
                    if (!dbus_g_proxy_call (gaim, "GaimAccountGetProtocolId",
                                          &error,
                                          G_TYPE_INT,
                                          account,
                                          G_TYPE_INVALID,
                                          G_TYPE_STRING,
                                          &protocol_id,
                                          G_TYPE_INVALID))
                      {
                        throw GaimDbusError (error->message);
                      }

                    // Get protocol name 
                    if (!dbus_g_proxy_call (gaim, "GaimAccountGetProtocolName",
                                          &error,
                                          G_TYPE_INT,
                                          account,
                                          G_TYPE_INVALID,
                                          G_TYPE_STRING,
                                          &protocol_name,
                                          G_TYPE_INVALID))
                      {
                        throw GaimDbusError (error->message);
                      }

                    buddy.name          = name;
                    buddy.alias         = alias;
                    buddy.protocol_name = protocol_name;
                    buddy.protocol_id   = protocol_id;
                    buddy.account       = account;
                    buddy.connection    = connection;
                    buddy.contact       = contact;
                    buddy.icon          = icon;

                    buddies.push_back (buddy);
                  }
            }
  
          int current_node = node;
          if (!dbus_g_proxy_call (gaim, "GaimBlistNodeNext",
                                  &error,
                                  G_TYPE_INT,
                                  current_node,
                                  G_TYPE_INT,
                                  int(0),
                                  G_TYPE_INVALID,
                                  G_TYPE_INT,
                                  &node,
                                  G_TYPE_INVALID))
            {
              throw GaimDbusError (error->message);
            }
        }
    }

    void  
    DBUS::send_file (Buddy const& buddy, std::string const& filename)
    {
      GError *error = 0;
      if (!dbus_g_proxy_call (gaim, "ServSendFile",
                                  &error,
                                  G_TYPE_INT,
                                  buddy.connection,
                                  G_TYPE_STRING,
                                  buddy.name.c_str(),
                                  G_TYPE_STRING,
                                  filename.c_str(),
                                  G_TYPE_INVALID))
        {
          throw GaimDbusError (error->message);
        }
    }

  } // namespace Gaim
} // namespace Bmp
