//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_LIBRARY_UI_MODIFY_HH
#define BMP_LIBRARY_UI_MODIFY_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <glibmm.h>
#include <glibmm/markup.h>
#include <gtkmm.h>
#include <libglademm.h>

#include "amazon.hh"
#include "library.hh"
#include "mbxml.hh"
#include "vfs.hh"

namespace Bmp
{
  class LibraryUiModify : public Gtk::Dialog
  {
    public:

        struct ModifyTracks
        {
          Library::UTrackV  tracks;
          Library::Album    album;
        };

        LibraryUiModify (BaseObjectType *cobject, const Glib::RefPtr<Gnome::Glade::Xml> &xml);
        static LibraryUiModify * create ();

#ifdef HAVE_HAL

        int run (MusicBrainzXML::MBReleaseV const& releases, Bmp::VUriVrpPair const& list, ModifyTracks &tracks); 
#else

        int run (MusicBrainzXML::MBReleaseV const& releases, Bmp::VUri const& list, ModifyTracks &tracks); 

#endif //HAVE_HAL

    private:

        void artist_changed	();
        void album_changed	();
        void on_action_update();
    
        // ColumnRecord Artists
        class ColumnRecordArtist : public Gtk::TreeModel::ColumnRecord
        {
          public:
            Gtk::TreeModelColumn<Glib::ustring> name;
            Gtk::TreeModelColumn<Glib::ustring> id; // Artist ID
            ColumnRecordArtist ()
            {
              add (name);
              add (id);
            }
        };
        ColumnRecordArtist artists;

        // ColumnRecord Albums
        class ColumnRecordAlbum : public Gtk::TreeModel::ColumnRecord
        {
          public:
            Gtk::TreeModelColumn<Glib::ustring> name;
            Gtk::TreeModelColumn<Glib::ustring> id; // Release ID
            ColumnRecordAlbum ()
            {
              add (name);
              add (id);
            }
        };
        ColumnRecordAlbum albums;

        // ColumnRecord Release
        class ColumnRecordTrack : public Gtk::TreeModel::ColumnRecord
        {
          public:
            Gtk::TreeModelColumn<unsigned int>                          tracknumber;
            Gtk::TreeModelColumn<Glib::ustring>                         title;
            Gtk::TreeModelColumn<Bmp::MusicBrainzXML::MBTrack>          track;
            ColumnRecordTrack ()
            {
              add (tracknumber);
              add (title);
              add (track);
            }
        };
        ColumnRecordTrack tracks_release;

#ifdef HAVE_OFA
        enum PuidState
        {
          P_NONE,
          P_PUID,
          P_PUID_METADATA,
        };
#endif //HAVE_OFA

        // ColumnRecord Local
        class ColumnRecordUTrack : public Gtk::TreeModel::ColumnRecord
        {
          public:

            Gtk::TreeModelColumn<bool>	                        modify;
            Gtk::TreeModelColumn<unsigned int>                  tracknumber;
            Gtk::TreeModelColumn<Glib::ustring>                 title;
            Gtk::TreeModelColumn<Glib::ustring>                 location;
            Gtk::TreeModelColumn<Bmp::MusicBrainzXML::MBTrack>  track;

#ifdef HAVE_OFA
            Gtk::TreeModelColumn<PuidState>                     puidstate;
            Gtk::TreeModelColumn<Glib::ustring>                 puid;
#endif //HAVE_OFA

#ifdef HAVE_HAL
            Gtk::TreeModelColumn<Glib::ustring>                 volume_udi;
            Gtk::TreeModelColumn<Glib::ustring>                 volume_relative_path;
#endif //HAVE_HAL


            ColumnRecordUTrack ()
            {
              add (modify);
              add (tracknumber);
              add (title);
              add (location);
              add (track);

#ifdef HAVE_OFA
              add (puidstate);
              add (puid);
#endif //HAVE_OFA

#ifdef HAVE_HAL
              add (volume_udi);
              add (volume_relative_path);
#endif //HAVE_HAL

            }
        };
        ColumnRecordUTrack tracks_local;

        typedef std::map<Glib::ustring, MusicBrainzXML::MBRelease> ReleaseMap;
        ReleaseMap merge_releases;

        typedef std::vector<Glib::ustring> ReleaseIdV;
        typedef std::map<Glib::ustring, ReleaseIdV> ArtistReleaseMap; 
        ArtistReleaseMap merge_map;

        Glib::RefPtr<Gnome::Glade::Xml> m_ref_xml;

        Gtk::ComboBoxEntry *merge_cb_artist;
        Gtk::ComboBoxEntry *merge_cb_album;

        Gtk::Entry *merge_cb_artist_entry;
        Gtk::Entry *merge_cb_album_entry;

        Gtk::ComboBoxEntry  *cb_genre;
        Gtk::Entry          *cb_genre_entry;
        Gtk::CheckButton    *cb_modify_genre;

        Glib::RefPtr<Gtk::ListStore> merge_cb_artist_store;
        Glib::RefPtr<Gtk::ListStore> merge_cb_album_store;

        Glib::RefPtr<Gdk::Pixbuf>	m_album_unknown;

        Gtk::Image        * merge_coverart;

        Gtk::Entry        * merge_artist_id;
        Gtk::Entry        * merge_release_id;
        Gtk::Entry        * merge_asin;
        Gtk::Entry        * merge_score;

        Gtk::Label        * l_tracks;

        Gtk::Button       * cancel;
        Gtk::Button       * ok;

        Gtk::Button       * b_move_up;
        Gtk::Button       * b_move_down;
        Gtk::Button       * b_update;

        Gtk::TreeView	    * view_release;
        Gtk::TreeView     * view_local;

        Gtk::ProgressBar  * progress_processing;

        Glib::RefPtr<Gtk::ListStore> store_release;
        Glib::RefPtr<Gtk::ListStore> store_local;

#ifdef HAVE_HAL

        Bmp::VUriVrpPair    m_list;
        Bmp::VUriVrpPair    m_list_original;

#else

        Bmp::VUri           m_list; 
        Bmp::VUri           m_list_original; 

#endif //HAVE_HAL

        MusicBrainzXML::MBRelease m_release;

        void cell_data_func_number (Gtk::CellRenderer* cell, const Gtk::TreeModel::iterator& iter);
        void cell_data_func_puidstate (Gtk::CellRenderer* cell, const Gtk::TreeModel::iterator& iter);
 
        void local_selection_changed ();
        void populate_data (MusicBrainzXML::MBReleaseV& releases);

        enum OrderingType
        {
          ORDER_LINEAR,
          ORDER_TRACKNUMBERS,
          ORDER_LEVENSHTEIN,
          ORDER_AUTO,
        };

        OrderingType m_current_ordering;

        void populate_local_store (OrderingType order_type_specified);

        void on_action_down ();
        void on_action_up ();
        void on_action_remove ();
        void on_action_relayout (OrderingType order_type_specified);
        void on_action_restore ();

        void on_action_use_filenames_toggled ();

#ifdef HAVE_OFA

        void on_action_scan ();
        void on_action_scan_file ();
        void on_action_scan_all ();
        void on_action_submit_puids ();

        void set_local_puidstate (Gtk::TreeModel::iterator& m_iter, PuidState state);

        static int http_auth (gpointer data, const char *realm, int attempts, char *username, char *password);

#endif //HAVE_OFA

        bool popup_rhs_menu (GdkEvent *ev);
        void on_mod_toggled (Glib::ustring const& path);

        Glib::RefPtr<Gtk::UIManager>    m_ui_manager;
        Glib::RefPtr<Gtk::ActionGroup>  m_actions;
        Glib::RefPtr<Gtk::ToggleAction> m_action_use_filenames;
  };
}
#endif
