//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef STREAMS_ICECAST_HH
#define STREAMS_ICECAST_HH

#include <gtkmm.h>
#include <libglademm.h>

namespace Bmp
{
  namespace Streams
  {

    struct IcecastEntry
    {
      Glib::ustring   server_name;
      Glib::ustring   listen_url;
      Glib::ustring   server_type;
      Glib::ustring   genre; 

      unsigned int    channels; 
      unsigned int    samplerate; 
      unsigned int    bitrate;

      IcecastEntry () : channels (0), samplerate (0), bitrate (0) {}
    };
    typedef std::vector < IcecastEntry > VIcecastEntries;
 
    class IcecastParser 
        : public Glib::Markup::Parser
    {
      public:

        IcecastParser (VIcecastEntries & entries); 
        virtual ~IcecastParser ();

        void check_sanity ();

      protected:

        virtual void
        on_start_element  (Glib::Markup::ParseContext& context,
                           Glib::ustring const& elementname,
                           const AttributeMap& attributes);
        virtual void
        on_end_element    (Glib::Markup::ParseContext& context,
                           Glib::ustring const& elementname);
        virtual void
        on_text	          (Glib::Markup::ParseContext& context,
                           Glib::ustring const& text);
      private:

        VIcecastEntries & m_entries;

        enum Element
        {
          E_NONE	       = 0, 
          E_DIRECTORY    = 1 << 0,
          E_ENTRY        = 1 << 1,
          E_SERVER_NAME  = 1 << 2,
          E_LISTEN_URL   = 1 << 3,
          E_SERVER_TYPE  = 1 << 4,
          E_BITRATE      = 1 << 5,
          E_CHANNELS     = 1 << 6,
          E_SAMPLERATE   = 1 << 7,
          E_GENRE        = 1 << 8,
          E_CURRENT_SONG = 1 << 9,
        };

        IcecastEntry entry;   
    
        int state;
    };

      class Icecast : public Gtk::TreeView
      {
        public:

          Icecast (BaseObjectType                       * cobject,
                   Glib::RefPtr<Gnome::Glade::Xml> const& xml);
          ~Icecast () {}

          void refresh ();
          void filter (Glib::ustring const& filter);
          void get_stream (Glib::ustring& title, Glib::ustring& uri);

        private:

          class Columns : public Gtk::TreeModel::ColumnRecord
          {
            public:

              Gtk::TreeModelColumn<Glib::ustring> name;
              Gtk::TreeModelColumn<unsigned int>  bitrate;
              Gtk::TreeModelColumn<Glib::ustring> genre;
              Gtk::TreeModelColumn<Glib::ustring> uri;

              Columns ()
              {
                add (name);
                add (bitrate);
                add (genre);
                add (uri);
              }
          };
          Columns columns; 

          bool visible_func (Gtk::TreeModel::iterator const& iter);
          void column_clicked (int column);

          Glib::RefPtr<Gnome::Glade::Xml>     m_ref_xml;
          Glib::RefPtr<Gtk::ListStore>        m_streams;
          Glib::RefPtr<Gtk::TreeModelFilter>  m_filtered;
          Glib::ustring                       m_filter;

      };  // class Icecast

  }  // namespace Streams 

}  // namespace Bmp 

#endif // !STREAM_LISTER_HH
