//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_UI_PART_ICECAST_STREAMS_HH 
#define BMP_UI_PART_ICECAST_STREAMS_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtkmm.h>
#include <libglademm.h>

#include <boost/shared_ptr.hpp>
#include <boost/optional.hpp>

#include "streams-icecast.hh"

#include "playbacksource.hh"
#include "ui-part-base.hh"

namespace Bmp
{
  namespace UiPart
  {
    class IcecastStreams : public Bmp::PlaybackSource, public Bmp::UiPart::Base
    {
      private:

        Bmp::Streams::Icecast *icecast;

        void
        play_set_title (const char *title);

        void
        refresh (Gtk::Notebook *notebook);

        void
        selection_changed ();

        void
        activate_default (Gtk::TreeModel::Path const& path, Gtk::TreeViewColumn* column);

        sigc::connection title_conn;

      protected:

        virtual guint
        add_ui ();

        virtual Glib::ustring
        get_uri ();

        virtual Glib::ustring
        get_type () { return Glib::ustring(); }

        virtual bool
        go_next ();

        virtual bool
        go_prev ();

        virtual void
        stop ();

        virtual void
        play ();

        virtual void
        play_requested () {}

        virtual void
        restore_context ();

        virtual GHashTable*
        get_metadata () { return NULL; }

      private:

        boost::optional<Glib::ustring> m_current_title;
        boost::optional<Glib::ustring> m_current_name;
        boost::optional<Glib::ustring> m_current_uri;

      public:

        IcecastStreams (Glib::RefPtr<Gnome::Glade::Xml> const& xml, Glib::RefPtr<Gtk::UIManager> ui_manager);
        ~IcecastStreams () {};
    };
  }
}
#endif
