/***************************************************************************
                          dlgmain.h  -  description
                             -------------------
    begin                : Sat Dec 28 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kschenke at users dot sourceforge dot net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA         *
 *   02110-1301, USA                                                       *
 *                                                                         *
 ***************************************************************************/

#ifndef DLGMAIN_H
#define DLGMAIN_H

#include <QDialog>
#include "ui_dlgmain.h"
#include "bridgecfg.h"

/***************************************************************************
 *                                                                         *
 *   Forward declarations.                                                 *
 *                                                                         *
 ***************************************************************************/

class DlgHelp;

/***************************************************************************
 *                                                                         *
 *   The DlgMain class represents the main dialog box that serves as       *
 *   BookmarkBridge's primary interface.                                   *
 *                                                                         *
 ***************************************************************************/

class DlgMain : public QDialog, public Ui::DlgMain
{
	Q_OBJECT;

public:
	DlgMain( QWidget* parent = 0 );
	virtual ~DlgMain();

public slots:
	void on_buttonAbout_clicked(void);
	void on_buttonDestAdd_clicked(void); 
	void on_buttonHelp_clicked(void);
	void on_buttonSettings_clicked(void);
	void on_buttonSourceAdd_clicked(void); 
	void on_buttonView_clicked(void);
	void on_listSources_currentRowChanged(void);
	void on_listDestinations_currentRowChanged(void);
	void on_buttonSourceDelete_clicked(void);
	void on_buttonDestDelete_clicked(void);
	void on_buttonMerge_clicked(void);

private:
	BridgeCfg	m_cfg;
	DlgHelp *	m_dlgHelp;

	void		refreshButtons(void);
	void		refreshLists(void);
};

#endif	// end of DLGMAIN_H
