<?php
# ---------------------------------------------------------------
# bookmarker
# A WWW based bookmark management, retrieval, and search tool.
# Copyright (C) 1998  Padraic Renaghan
# Licensed under terms of GNU General Public License
# (see http://www.renaghan.com/bookmarker/source/LICENSE)
# ---------------------------------------------------------------
# $Id: auto_init.inc,v 1.3 2000/01/16 17:52:55 prenagha Exp $
# ---------------------------------------------------------------
# make all sess and user variables global so they
# are available in other scripts immediately.
global $sess_msg, $sess_warn_msg, $sess_error_msg;

# this file is executed ONCE at the startup of each session.
# we use this file to register session/user variables once, so
# that they are easily available to all pages.

# these session variables allow us to pass error, warning
# and information messages between pages
$sess->register("sess_msg");
$sess->register("sess_warn_msg");
$sess->register("sess_error_msg");

if (isset($user)) {
  # get/set the $user_total_bookmarks as a user variable.
  # we use this to keep the total nbr of bookmarks this
  # user has so we can calculate the list pages correctly.
  $user->register("user_total_bookmarks");
  $bmark = new bmark;
  $bmark->update_user_total_bookmarks($auth->auth["uname"]);

  # get/set the $user_last_page as a user variable.
  # we use this to keep the last page nbr that the user
  # was looking at so we can default in the future.
  $user->register("user_last_page");
}
?>
