#! /bin/bash
# s390-tape kernel preparation for boot-floppies
#
# written by Gerhard Tonn and Stefan Gybas, 2001/2002
# maintained by the boot-floppies team, debian-boot@lists.debian.org
#   copyright (c) 1999 -- 2002
# This is free software under the GNU General Public License.
 
set -e
 
. ./common.sh
 
if [ $# -lt 1 ]; then
    echo "usage: $0 archive" 1>&2
    cat 1>&2 << EOF
 
        archive: the directory where Debian binary packages will be downloaded
EOF
    exit -1
fi
 
archive=$1
#shift 3
 
testroot
 
extractdir=${tmpdir}/boot-floppies/extract-tmp-$$
rm -rf $extractdir
make_tmpdir $extractdir

udebdir="kernel-image-2.4.17-s390"
udebname="kernel-image-2.4.17-s390-tape-udeb_2.4.17-1_s390.udeb"
 
info "downloading $udebname"
if [ ! -f $archive/var/cache/apt/archives/$udebname ]; then
  (cd $archive/var/cache/apt/archives/; wget $MIRRORS/pool/main/k/$udebdir/$udebname)
fi
 
info "extracting $udebnameto extract area, '$extractdir'"
dpkg-deb --extract $archive/var/cache/apt/archives/$udebname $extractdir
 
info "creating 'linuxs390-tape'"
cp $extractdir/boot/vmlinuz* linuxs390-tape
cp $extractdir/boot/config* configs390-tape.gz
cp $extractdir/boot/System.map* sys_maps390-tape.gz

info "creating 'linuxs390-tape-nolabel'"
(dd bs=1 count=8 && dd bs=1 skip=1 count=0 && printf "\007" && dd) \
	< linuxs390-tape > linuxs390-tape-nolabel
 
exit 0
