#!	/bin/bash

. ./common.sh

# Print a usage message and exit if the argument count is wrong.
if [ $# != 2 ]; then
	echo "Usage: "$0" old-floppy new-floppy" 1>&2
	cat 1>&2 << EOF

	old-floppy: Floppy image to modify.
	new-floppy: name for the modified floppy image.
EOF
	exit -1
fi

oldf=$1
newf=$2

info "making safe version of $oldf in $newf"

relax
cp $oldf $newf.tmp
relax
syslinux -s $newf.tmp
rm -rf $newf
mv $newf.tmp $newf

info "safe image complete:"
ls -l $newf
exit 0
