#include "dbootstrap.h"
#include <stdio.h>
#include "lang.h"
#include "kbdconfig.h"
#include <syslog.h> 
#include "util.h"

int configure_keyboard_m (void) {
	return configure_keyboard(NULL);
}

int configure_keyboard (char *kbd)
{
  int rs=-1;
  char *prefix;
  char *msg=_("Please select a keyboard. If you don't find the exact right choice below, please choose something close.\nYou'll be able to configure more keyboard choices by running 'dpkg-reconfigure console-data' once you have installed the base system.");
  char *title=_("Select a keyboard");

#if #cpu (m68k)
  struct d_choices keymaps_ami[]={
    { "amiga-de",        _("German (Amiga)")            , KBD_de_DE },
    { "amiga-es",        _("Spanish (Amiga)")           , KBD_es_ES },
    { "amiga-fr",        _("French (Amiga)")            , KBD_fr_FR },
    { "amiga-it",        _("Italian (Amiga)")           , KBD_it_IT },
    { "amiga-us",        _("U.S. English (Amiga)")      , KBD_C },
    { "amiga-se",        _("Swedish (Amiga)")           , KBD_sv_SE },
    { "amiga-sg",        _("Swiss German (Amiga)")      , KBD_de_CH }
  };
  int nchoices_ami=sizeof(keymaps_ami)/sizeof(struct d_choices);
  struct d_choices keymaps_ata[]={
    { "atari-us",        _("U.S. English (Atari)")      , KBD_C },
    { "atari-de",        _("German (Atari)")            , KBD_de_DE },
    { "atari-se",        _("Swedish (Atari)")           , KBD_sv_SE },
    { "atari-uk",        _("U.K. English (Atari)")      , KBD_en_UK },
  };
  int nchoices_ata=sizeof(keymaps_ata)/sizeof(struct d_choices);
  struct d_choices keymaps_mac[]={
    { "mac-us-std",      _("U.S. English (Mac, 82 keys)")     , KBD_C },
    { "mac-us-ext",      _("U.S. English (Mac, extended kbd)"), 0 },
/* removed 24.09.2001, cts
    { "mac-de-latin1-nodeadkeys",    "German (Mac)"        , KBD_de_DE },
*/
    { "mac-de2-ext",     _("German (Mac, extended kbd)")      , 0 },
    { "mac-fr2-ext",     _("French (Mac, extended kbd)")      , KBD_fr_FR },
    { "mac-fr3",         _("French (Mac, alternate)")         , 0 },
  };
  int nchoices_mac=sizeof(keymaps_mac)/sizeof(struct d_choices);
#elif #cpu (powerpc)
  struct d_choices keymaps[]={
    { "qwerty/us",                  _("U.S. English (QWERTY)")    , KBD_C },
    { "azerty/be-latin1",           _("Belgian")                  , KBD_fr_BE },
    { "qwerty/br-abnt2",            _("Brazilian (ABNT2 layout)") , KBD_pt_BR2 }, 
    { "qwerty/br-latin1",           _("Brazilian (EUA layout)")   , KBD_pt_BR },
    { "qwerty/bg",                  _("Bulgarian Cyrillic")       , 0 },
    { "qwertz/croat",               _("Croatian")                 , 0 },
    { "qwerty/cz-lat2",             _("Czech")                    , KBD_cs_CZ },
    { "qwerty/dk-latin1",           _("Danish")                   , KBD_da_DK },
    { "dvorak/dvorak",              _("Dvorak")                   , 0 },
    { "qwerty/es",                  _("Spanish")                  , KBD_es_ES },
    { "qwerty/fi-latin1",           _("Finnish")                  , KBD_fi_FI },
    { "azerty/fr-latin0",           _("French (with Euro)")       , KBD_fr_FR0 },
    { "azerty/fr-latin1",           _("French")                   , KBD_fr_FR },
    { "qwerty/cf",                  _("French Canadian")          , KBD_fr_CA },
    { "qwertz/de-latin1-nodeadkeys",_("German")                   , KBD_de_DE },
    /* removed 2002-01-07 pb
    { "qwerty/gr",                  "Greek"                    , KBD_el_GR },
    */
    { "qwerty/hebrew",              _("Hebrew")                   , 0 },
    { "qwertz/hu",                  _("Hungarian")                , KBD_hu_HU },
    { "qwerty/is-latin1",           _("Icelandic")                , KBD_is_IS },
    { "qwerty/it",                  _("Italian")                  , KBD_it_IT },
    { "qwerty/jp106",               _("Japanese")                 , KBD_ja_JP },
    { "qwerty/no-latin1",           _("Norwegian")                , KBD_no_NO },
    { "qwerty/pl",                  _("Polish")                   , KBD_pl_PL },
    { "qwerty/pt-latin1",           _("Portuguese")               , KBD_pt_PT },
    { "qwerty/ru",                  _("Russian")                  , KBD_ru_RU },
    { "qwerty/se-latin1",           _("Swedish")                  , KBD_sv_SE },
    { "qwertz/slovene",             _("Slovene")                  , 0 },
    { "qwerty/sk-qwerty",           _("Slovak")                   , 0 },
    { "qwertz/fr_CH-latin1",        _("Swiss French")             , 0 },
    { "qwertz/sg-latin1",           _("Swiss German")             , 0 },
    { "qwerty/trq",                 _("Turkish Q")                , KBD_tr_TR },
    { "qwerty/uk",                  _("U.K. English")             , KBD_en_UK },
  };
  struct d_choices keymaps_mac[]={
    { "qwerty/mac-usb-us",      _("U.S. English (Apple USB)")        , 0 },
    { "qwerty/us",              _("U.S. English (Standard)")         , KBD_C },
    { "azerty/mac-usb-fr",      _("French (Apple USB)")              , KBD_fr_FR },
    { "qwertz/mac-usb-de-latin1-nodeadkeys", _("German (Apple USB)") , KBD_de_DE },
  };
  int nchoices_mac=sizeof(keymaps_mac)/sizeof(struct d_choices);
  struct d_choices keymaps_ami[]={
    { "amiga-us",        _("U.S. English (Amiga)")      , KBD_C },
    { "amiga-fr",        _("French (Amiga)")            , KBD_fr_FR },
    { "amiga-de",        _("German (Amiga)")            , KBD_de_DE },
    { "amiga-it",        _("Italian (Amiga)")           , KBD_it_IT },
    { "amiga-es",        _("Spanish (Amiga)")           , KBD_es_ES },
    { "amiga-se",        _("Swedish (Amiga)")           , KBD_sv_SE },
    { "amiga-sg",        _("Swiss German (Amiga)")      , KBD_de_CH }
  };
  int nchoices_ami=sizeof(keymaps_ami)/sizeof(struct d_choices);
#elif #cpu (sparc)
  struct d_choices keymaps[]={
    { "sun/sunkeymap",          _("U.S. (Type 4/5)")       , KBD_C },
    { "i386/qwerty/us",         _("U.S. (PS2/USB)")        , 0 },
    { "sun/sundvorak",          _("Dvorak (Type 4/5)")     , KBD_dvorak },
    { "sun/sunt5-fi-latin1",    _("Finnish (Type 5)")      , KBD_fi_FI },
    { "sun/sunt5-fr-latin1",    _("French (Type 5)")       , KBD_fr_FR },
    { "sun/sunt5-de-latin1",    _("German (Type 5)")       , KBD_de_DE },
    { "sun/sunt5-ru",           _("Russian (Type 5)")      , KBD_ru_RU },
    { "sun/sunt4-es",           _("Spanish (Type 4)")      , KBD_es_ES },
    { "sun/sunt5-es",           _("Spanish (Type 5)")      , 0 },
    { "sun/sun-pl",             _("Polish (Type 4/5)")     , KBD_pl_PL },
    { "sun/sunt5-cz-us",        _("Czech (Type 5)")        , KBD_cs_CZ },
    { "sun/sunt5-uk",           _("U.K. (Type 5)")         , KBD_en_UK }
  };
#elif #cpu (arm)
  struct d_choices keymaps[]={
    { "qwerty/us",              _("U.S. English (QWERTY)")   , KBD_C },
    { "azerty/be-latin1",       _("Belgian")                 , KBD_fr_BE },
    { "qwerty/br-abnt2",        _("Brazilian (ABNT2 layout)"), KBD_pt_BR2 },
    { "qwerty/br-latin1",       _("Brazilian (EUA layout)")  , KBD_pt_BR }, 
    { "qwerty/bg",              _("Bulgarian Cyrillic")      , 0 },
    { "qwertz/croat",           _("Croatian")                , 0 },
    { "qwerty/cz-lat2",         _("Czech")                   , KBD_cs_CZ },
    { "qwerty/dk-latin1",       _("Danish")                  , KBD_da_DK },
    { "dvorak/dvorak",          _("Dvorak")                  , KBD_dvorak },
    { "qwerty/fi-latin1",       _("Finnish")                 , KBD_fi_FI },
    { "azerty/fr-latin0",       _("French (with Euro)")      , KBD_fr_FR0 },
    { "azerty/fr-latin1",       _("French")                  , KBD_fr_FR },
    { "qwerty/cf",              _("French Canadian")         , KBD_fr_CA },
    { "qwertz/de-latin1-nodeadkeys", _("German")             , KBD_de_DE },
    /* removed 2002-01-07 pb
    { "qwerty/gr",              "Greek"                   , KBD_el_GR },
    */
    { "qwerty/hebrew",          _("Hebrew")                  , 0 },
    { "qwertz/hu",              _("Hungarian")               , KBD_hu_HU },
    { "qwerty/is-latin1",       _("Icelandic")               , KBD_is_IS },
    { "qwerty/it",              _("Italian")                 , KBD_it_IT },
    { "qwerty/jp106",           _("Japanese")                , KBD_ja_JP },
    { "qwerty/no-latin1",       _("Norwegian")               , KBD_no_NO },
    { "qwerty/pl",              _("Polish")                  , KBD_pl_PL },
    { "qwerty/pt-latin1",       _("Portuguese")              , KBD_pt_PT },
    { "qwerty/ru",              _("Russian")                 , KBD_ru_RU },
    { "qwerty/se-latin1",       _("Swedish")                 , KBD_sv_SE },
    { "qwertz/slovene",         _("Slovene")                 , 0 },
    { "qwerty/sk-qwerty",       _("Slovak")                  , 0 },
    { "qwerty/es",              _("Spanish")                 , KBD_es_ES },
    { "qwertz/fr_CH-latin1",    _("Swiss French")            , 0 },
    { "qwertz/sg-latin1",       _("Swiss German")            , 0 },
    { "qwerty/trq",             _("Turkish Q")               , KBD_tr_TR },
    { "qwerty/uk",              _("U.K. English")            , KBD_en_UK }
  };
#elif #cpu (mips)
  struct d_choices keymaps[]={
    { "qwerty/us",              _("U.S. English (QWERTY)") , KBD_C },
    { "azerty/be-latin1",       _("Belgian")               , KBD_fr_BE },
    { "qwerty/bg",              _("Bulgarian Cyrillic")    , 0 },
    { "qwertz/croat",           _("Croatian")              , 0 },
    { "qwerty/cz-lat2",         _("Czech")                 , KBD_cs_CZ },
    { "qwerty/dk-latin1",       _("Danish")                , KBD_da_DK },
    { "dvorak/dvorak",          _("Dvorak")                , KBD_dvorak },
    { "qwerty/fi-latin1",       _("Finnish")               , KBD_fi_FI },
    { "azerty/fr-latin0",       _("French (with Euro)")    , KBD_fr_FR0 },
    { "azerty/fr-latin1",       _("French")                , KBD_fr_FR },
    { "qwerty/cf",              _("French Canadian")       , KBD_fr_CA },
    { "qwertz/de-latin1-nodeadkeys", _("German")           , KBD_de_DE },
    /* removed 2002-01-07 pb
    { "qwerty/gr",              "Greek"                 , KBD_el_GR },
    */
    { "qwerty/hebrew",          _("Hebrew")                , 0 },
    { "qwertz/hu",              _("Hungarian")             , KBD_hu_HU },
    { "qwerty/is-latin1",       _("Icelandic")             , KBD_is_IS },
    { "qwerty/it",              _("Italian")               , KBD_it_IT },
    { "qwerty/jp106",           _("Japanese")              , KBD_ja_JP },
    { "qwerty/no-latin1",       _("Norwegian")             , KBD_no_NO },
    { "qwerty/pl",              _("Polish")                , KBD_pl_PL },
    { "qwerty/pt-latin1",       _("Portuguese")            , KBD_pt_PT },
    { "qwerty/ru",              _("Russian")               , KBD_ru_RU },
    { "qwerty/se-latin1",       _("Swedish")               , KBD_sv_SE },
    { "qwertz/slovene",         _("Slovene")               , 0 },
    { "qwerty/sk-qwerty",       _("Slovak")                , 0 },
    { "qwerty/es",              _("Spanish")               , KBD_es_ES },
    { "qwertz/fr_CH-latin1",    _("Swiss French")          , 0 },
    { "qwertz/sg-latin1",       _("Swiss German")          , 0 },
    { "qwerty/trq",             _("Turkish Q")             , KBD_tr_TR },
    { "qwerty/uk",              _("U.K. English")          , KBD_en_UK }
  };
#else
  struct d_choices keymaps[]={
    { "qwerty/us",              _("U.S. English (QWERTY)") , KBD_C },
    { "azerty/be-latin1",       _("Belgian")               , KBD_fr_BE },
    { "qwerty/br-abnt2",        _("Brazilian (ABNT2 layout)"), KBD_pt_BR2 },
    { "qwerty/br-latin1",       _("Brazilian (EUA layout)"), KBD_pt_BR }, 
    { "qwerty/bg",              _("Bulgarian Cyrillic")    , 0 },
    { "qwertz/croat",           _("Croatian")              , 0 },
    { "qwerty/cz-lat2",         _("Czech")                 , KBD_cs_CZ },
    { "qwerty/dk-latin1",       _("Danish")                , KBD_da_DK },
    { "dvorak/dvorak",          _("Dvorak")                , KBD_dvorak },
    { "qwerty/fi-latin1",       _("Finnish")               , KBD_fi_FI },
    { "azerty/fr-latin0",       _("French (with Euro)")    , KBD_fr_FR0 },
    { "azerty/fr-latin1",       _("French")                , KBD_fr_FR },
    { "qwerty/cf",              _("French Canadian")       , KBD_fr_CA },
    { "qwertz/de-latin1-nodeadkeys", _("German")           , KBD_de_DE },
    /* removed 2002-01-07 pb
    { "qwerty/gr",              "Greek"                 , KBD_el_GR },
    */
    { "qwerty/hebrew",          _("Hebrew")                , 0 },
    { "qwertz/hu",              _("Hungarian")             , KBD_hu_HU },
    { "qwerty/is-latin1",       _("Icelandic")             , KBD_is_IS },
    { "qwerty/it",              _("Italian")               , KBD_it_IT },
    { "qwerty/jp106",           _("Japanese")              , KBD_ja_JP },
    { "qwerty/no-latin1",       _("Norwegian")             , KBD_no_NO },
    { "qwerty/pl",              _("Polish")                , KBD_pl_PL },
    { "qwerty/pt-latin1",       _("Portuguese")            , KBD_pt_PT },
    { "qwerty/ru",              _("Russian")               , KBD_ru_RU },
    { "qwerty/se-latin1",       _("Swedish")               , KBD_sv_SE },
    { "qwertz/slovene",         _("Slovene")               , 0 },
    { "qwerty/sk-qwerty",       _("Slovak")                , 0 },
    { "qwerty/es",              _("Spanish")               , KBD_es_ES },
    { "qwertz/fr_CH-latin1",    _("Swiss French")          , 0 },
    { "qwertz/sg-latin1",       _("Swiss German")          , 0 },
    { "qwerty/trq",             _("Turkish Q")             , KBD_tr_TR },
    { "qwerty/uk",              _("U.K. English")          , KBD_en_UK }
  };
#endif
  int nchoices;
  struct d_choices* choices;

#if #cpu (m68k)
    if (strcmp(Arch2, "Atari") == 0) {
        choices = keymaps_ata;
        nchoices = nchoices_ata;
        prefix="atari/";
    }
    else if (strcmp(Arch2, "Amiga") == 0) {
        choices = keymaps_ami;
        nchoices = nchoices_ami;
        prefix="amiga/";
    }
    else if (strcmp(Arch2, "Macintosh") == 0) {
        choices = keymaps_mac;
        nchoices = nchoices_mac;
        prefix="mac/";
    }
    else if (strcmp(Arch2, "VME") == 0) {
        problemBox(_("VME console does not support keymaps."),_("Information"));
        return 255;
    }
    else
        return 255;
#elif #cpu (sparc)
    prefix="";
    choices= keymaps;
    nchoices=sizeof(keymaps)/sizeof(struct d_choices);
#elif #cpu (powerpc)
    if (strcmp(Arch2, "apus") == 0) {
        choices = keymaps_ami;
        nchoices = nchoices_ami;
        prefix="amiga/";
    }
    else if (strstr(Arch2, "PowerMac") == 0) {
        choices = keymaps_mac;
        nchoices = nchoices_mac;
        prefix = "i386/";
    } else {
        choices= keymaps;
        nchoices=sizeof(keymaps)/sizeof(struct d_choices);
        prefix="i386/";
    }
#elif #cpu (arm)
    if (strcmp(Arch2, "riscpc") == 0) {
        prefix = "acorn/";
    } else {
        prefix = "i386/";
    }
    choices = keymaps;
    nchoices = sizeof(keymaps)/sizeof(struct d_choices);
#else
    prefix = "i386/";
    choices = keymaps;
    nchoices = sizeof(keymaps) / sizeof(struct d_choices);
#endif

    if (kbd) {
        int i;
        for (i=0;i<nchoices;i++) {
                if (0 == strcmp(choices[i].tag,kbd)) {
                        rs=i;
                        break;
                }
        }
        if (rs == -1)
                vaproblemBox(_("Problem"), 
                             _("Couldn't find a keyboard mapping file named '%s'.  If you used the 'kbd=<name>' boot parameter, the value passed as 'name' must be incorrect.\n\nPress <ENTER> to select a keyboard manually."),
                             kbd);
    }
    if (rs == -1) {
        int def = -1;
#ifdef USE_LANGUAGE_CHOOSER
        int i;
        if (lang->keymap) {
            char *p = strchr(lang->keymap, '/');
            if (p) {
                for (i = 0; i < nchoices; i++) {
                    if (strcmp(choices[i].tag, p + 1) == 0) {
                        def = i;
                        break;
                    }
                }
            }
        }
#endif
        rs=menuBox2(msg, title, choices, nchoices, 1, def);
    }

    if (rs != -1) {
        FILE *kbdconf;
        char *sprefix = prefix;
        if (NULL == (kbdconf = fopen(KEYBD_SETTINGS_FILE, "w"))) {
          vaproblemBox(_("Write error"),
                       _("Can't write to temporary user settings file %s"),
                       KEYBD_SETTINGS_FILE);
          return 1;
        }
#if #cpu (arm)
        if (strcmp(Arch2, "riscpc") == 0)
            sprefix = "i386/";
#endif
        fprintf(kbdconf, "KEYBD='%s%s'\n", sprefix, choices[rs].tag);
        fclose(kbdconf);
        sprintf(prtbuf,
                "zcat /etc/keymaps.tgz | tar -xOf - %s%s.bmap | loadkmap",
                prefix, choices[rs].tag);
#ifdef _TESTING_
        problemBox(prtbuf,"Test Box");
#else
        if ( execlog(prtbuf, LOG_INFO) != 0 ) {
          vaproblemBox(_("Keyboard load error"), 
                       _("Error loading the keymap %s%s.kmap from /etc/keymaps.tgz"),
                       prefix, choices[rs].tag);
          return 1;
        }
#endif
    }
#ifdef _TESTING_
    else {
        problemBox("Configuration Cancelled","Test Box");
    }
#endif
  return rs;
}


#ifdef _TESTING_
/* To test, compile using: make kbdconfig_test */
int main(void)
{
    LOAD_TRMFILE("test.trm");
    get_kver();
#if #cpu (m68k)
    Arch2 = "Atari";
#endif
    boxInit();

/* Use the following to test automatic kbd selection */
//    configure_keyboard("qwerty/es");

    configure_keyboard_m();

    boxFinished();
}
#endif

/*
  Local Variables:
  c-basic-offset: 4
  indent-tabs-mode: nil
*/
