#ifndef _STRETCH_CPP_
#define _STRETCH_CPP_

#include <iostream.h>

#include <reference.h>
#include <table.h>
#include <event.h>
#include <part.h>
#include <track.h>
#include <song.h>
#include <note.h>
#include <str.h>
#include <iterator.h>
#include <selectionIterator.h>

#include "stretch.h"

extern Table * selectioN;
extern Table * selectionMemory;

// #define STRETCH_CONTEXT Addon::TREAT_SELECTION + Addon::TREAT_TRACK + Addon::TREAT_PART + Addon::TREAT_SONG
#define STRETCH_CONTEXT Addon::TREAT_SELECTION + Addon::TREAT_TRACK + Addon::TREAT_PART + Addon::TREAT_SONG

extern "C" {
  Addon * stretch(Element * target) { return new Stretch(target); }
  const char  * stretch_name()     { return "stretch"; }
  const char  * stretch_category() { return "edit"; }
  int     stretch_context() { return STRETCH_CONTEXT; }
}


Stretch::Stretch(Element * target) : Addon("stretch element", target, !TO_BE_UNDONE, STRETCH_CONTEXT) { run(); }

Stretch::~Stretch() {

}

void Stretch::selection(Table * selection) {
  SelectionIterator i = SelectionIterator();
  Event * event = (Event*) *i;
  Position offset = event->internalStart();
  for (; !i.done(); i++) {
    event = (Event*) *i;
    event->setInternalStart(offset + (event->internalStart()-offset)*2);
    if (event->isA()==NOTE) ((Note*)event)->setDuration(((Note*)event)->duration()*2);
  }
}
void Stretch::part(Part * part) {
  for (Iterator i = Iterator(part); !i.done(); i++) {
    Event * event = (Event*) *i;
    Position pos = event->internalStart();
    pos = pos * 2;
    event->setInternalStart(pos);
    if (event->isA()==NOTE) ((Note*)event)->setDuration(((Note*)event)->duration()*2);
  }
}
void Stretch::track(Track * track) {
  for (int i=0; i<track->size(); i++) {
    Part * pt = (Part*) track->get(i);
    pt->setStart(pt->start()*2);
    part(pt);
  }
}

void Stretch::song(Song * song) {
  for (int i=0; i<song->size(); i++) {
    Track * tr = (Track*) song->get(i);
    track(tr);
  }
}

void Stretch::undo() {
}

void Stretch::redo() {
}






#endif
