
char *helptext = "
    bristol: a synthesiser emulation package.

    You should start this package with the startBristol script. This script
    will start up the bristol synthesiser binaries, evaluating the correct
    library paths and executable paths. There are emulation, synthesiser and
    operational parameters:

    Emulation:

        -mini             - mini moog
        -explorer         - moog voyager
        -hammond          - hammond module
        -b3               - dual manual hammond B3
        -pro5|-prophet    - sequential circuits prophet-5
        -pro10            - sequential circuits prophet-10
        -juno             - roland juno-6
        -dx               - yamaha DX-7
        -vox              - vox continental
        -rhodes           - fender rhodes stage 73
        -mixer            - 16 track mixer (-libtest only)

    Synthesiser:

        -voices <n>       - operate with a total of 'n' voices, default 16
        -channel <c>      - initial midi channel selected to 'c', default 1

    Operational:

        General:
            -engine       - don't start engine (connect to current invocation)
            -port <p>     - connect to engine on TCP port 'p' (default 5028)
            -libtest      - just display a GUI
            -quiet        - redirect output to /dev/null
            -oss          - use OSS defaults for audio and MIDI (default)
            -alsa         - use ALSA defaults for audio and MIDI

        Audio driver:
            -audio [oss|alsa]  - audio driver selection
            -audiodev <dev>    - audio device selection
            -bufsize <bytes>   - buffer size, default 1024 bytes (256 samples)
            -preload <buffers> - configure preload buffer count (default 4)
            -rate <hz>         - sample rate

        Midi driver:
            -midi [oss|alsa]   - midi driver selection
            -mididev <dev>     - midi device selection
            -seq               - use the ALSA SEQ interface

    Audio drivers are PCM or PCM plug only. Future releases may add Jack
    support. Midi drivers are either OSS/ALSA rawmidi interface, or ALSA SEQ.
    Multple GUIs can connect to the single audio engine, which then operates
    multitimbrally.

    Examples:

    startBristol

        Run a minimoog using OSS interface for audio and midi. This is
        equivalent to all the following options:
        -mini -audio oss -audiodev /dev/audio -midi oss -mididev /dev/midi
        -bufsize 1024 -preload 4 -port 5028 -voices 16 -channel 1 -rate 44100

    startBristol -alsa

        Run a minimoog using ALSA interface for audio and midi. This is
        equivalent to all the following options:
        -mini -audio alsa -audiodev plughw:0,0 -midi alsa -mididev hw:0
        -bufsize 1024 -preload 4 -port 5028 -voices 16 -channel 1 -rate 44100

    startBristol -explorer -voices 1

        Run a moog explorer as a monophonic instrument, using OSS interface for
        audio and midi.

    startBristol -prophet -alsa -channel 3

        Run a prophet-5 using ALSA for audio and midi (on channel 3).

    startBristol -b3 -bufsize 2048 -preload 2

        Run a hammond b3 with a buffer size of 2048 bytes (512 samples), and
        preload two such buffers before going active. Some Live! cards need 
        this larger buffer size with ALSA drivers.

    startBristol -oss -audiodev /dev/dsp1 -vox -voices 8

        Run a vox continental using OSS device 1, and default midi device
        /dev/midi0. Operate with just 8 voices.

    startBristol -b3 -audio alsa -audiodev plughw:0,0 -seq -mididev 128.0

        Run a B3 emulation over the ALSA PCM plug interface, using the ALSA
        sequencer over client 128, port 0.

    startBristol -juno &
    startBristol -prophet -channel 2 -engine

        Start two synthesisers, a juno and a prophet. Both synthesisers will
        will be executed on one engine (multitimbral) with 16 voices between 
        them. The juno will be on default midi channel (1), and the prophet on
        channel 2. Output over the same default OSS audio device (/dev/audio).

    startBristol -juno &
    startBristol -prophet -port 5029 -audiodev /dev/dsp1 -mididev /dev/midi1

        Start two synthesisers, a juno on the first OSS soundcard, and a
        prophet on the second OSS soundcard. Each synth is totally independant
        and runs with 16 voice polyphony (looks nice, but not been tested).

    Author: nick.copeland@ntlworld.com

";

