/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BSCommander is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BSCommander is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_FILEJOINER_H
#define INCLUDED_FILEJOINER_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QOBJECT_H
#include <qobject.h>
#define INCLUDED_QOBJECT_H
#endif // INCLUDED_QOBJECT_H

#ifndef INCLUDED_QSTRING_H
#include <qstring.h>
#define INCLUDED_QSTRING_H
#endif // INCLUDED_QSTRING_H

#ifndef INCLUDED_QDIALOG_H
#include <qdialog.h>
#define INCLUDED_QDIALOG_H
#endif // INCLUDED_QDIALOG_H

#ifndef INCLUDED_VIEWTABLE_H
#include "ViewTable.h"
#endif // INCLUDED_VIEWTABLE_H

/*------- forward declarations:
-------------------------------------------------------------------*/
class PleaseWait;

/*------- class declaration:
-------------------------------------------------------------------*/
class FileJoiner : public QObject
{
    Q_OBJECT

// ******* CONSTRUCTION / DESTRUCTION *******
public:
    FileJoiner( const ViewTable::SelectedItems&,
                const QString&,
                const QString& );
    ~FileJoiner();
private:
    FileJoiner( const FileJoiner& );
    FileJoiner& operator=( const FileJoiner& );

// ******* CONSTANTS *******
private:
    static const QString NotWritableDir;
    static const QString Caption;
    static const QString CanOverwarite;

// ******* MEMBERS *******
private:
    const ViewTable::SelectedItems d_items;
    const QString                  d_dst_dir;
    const QString                  d_dst_fname;
    PleaseWait*                    d_please_wait;

// ******* METHODS *******
public:
    void run();
private:
    void join              ( const QString&, QTextStream& );
    bool create_destination();
    bool can_write         ( const QString& );
private slots:
    void break_slot        ();
};

#endif // INCLUDED_FILEJOINER_H
