/******************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BSCommander is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BSCommander is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_PLEASEWAIT_H
#define INCLUDED_PLEASEWAIT_H

/*------- include files:
-------------------------------------------------------------------*/
#include <qdialog.h>

/*------ forward declarations:
-------------------------------------------------------------------*/
class QVBoxLayout;
class QHBoxLayout;
class QPushButton;
class QLabel;

/*------- class declaration:
-------------------------------------------------------------------*/
class PleaseWait : public QDialog
{
    Q_OBJECT
    
// ******* CONSTRUCTION / DESTRUCTION *******
public:
    PleaseWait( QWidget* );
    ~PleaseWait();
private:
    PleaseWait( const PleaseWait& );
    PleaseWait& operator=( const PleaseWait& );

// ******* CONSTANTS *******
private:
    static const QString PleaseWaitMsg;

// ******* MEMBERS *******
private:
    QVBoxLayout* const d_main_layout;
    QHBoxLayout* const d_info_layout;
    QHBoxLayout* const d_btn_layout;
    QHBoxLayout* const d_sep_layout;
    QLabel     * const d_message_lbl;
    QPushButton* const d_break_btn;

// ******* METHODS *******
public:
    void show();
    void message( const QString& );
    void caption( const QString& );
private:
    void customEvent( QCustomEvent * );
    void keyPressEvent( QKeyEvent* );
private slots:
    void break_work_slot();
signals:
    void break_work();
};

#endif // INCLUDED_PLEASEWAIT_H
