#!/bin/sh
# $Id: dotest.sh,v 1.13 2004/05/08 15:44:24 jmmv Exp $

LOGFILE=/tmp/bt-test.$$

runcmd() {
    echo "" >> $LOGFILE
    echo "--------------------------------------------------" >> $LOGFILE
    echo "RUNNING: $*" >> $LOGFILE
    $* 2>&1 | tee -a $LOGFILE
}

sendlog() {
    cat <<EOF


Submit log
----------

    This script has stored a log of all the process.  Take some time to
    examine it if you like; it is currently stored in:

        $LOGFILE

    When you have finished, please send that file without changes to me,
    Julio M. Merino Vidal <jmmv@users.sourceforge.net>, so I can analyze
    it.  Feel free to add any information you feel is missing to the mail
    you send.

EOF
}

dirs=`echo $PATH | tr ':' ' '`
found=""

for d in $dirs; do
    if [ -f $d/buildtool ]; then
        found="yes"
    fi
done

if [ -z "$found" ]; then
    echo "Buildtool binary not found.  Adjust PATH accordingly."
    exit 1
fi

rm -f $LOGFILE
touch $LOGFILE
echo "`uname -a`" > $LOGFILE

runcmd buildtool lint
runcmd buildtool config -p /tmp/testsuite -f developer=yes
runcmd buildtool clean
runcmd buildtool build
runcmd buildtool test
runcmd buildtool install
runcmd buildtool deinstall
runcmd buildtool dist

rm -f ../testsuite-*.tar.gz
rm -f ../testsuite-*.tar.bz2

rm -rf /tmp/testsuite

sendlog

cat <<EOF
    Thank you for your testing time.  Your feedback is really appreciated.

EOF

exit 0
