--
-- ACTUALIZACION DE LA BASE DE DATOS DE BULMAFACT
--


-- Ocultamos las noticias
SET client_min_messages TO warning;


BEGIN;

--
-- Estas primeras funciones cambiaran los tipos de columnas que estan como flotantes a NUMERIC.
-- Se trata de un parche que se desea aplicar para almacenar los tipos monetarios
-- ya que actualmente se encuantran almacenados como 'doubles' y es preferible
-- que se almacenen como tipo 'numeric'.
-- Todas devuelven como valor numerico el nmero de filas influenciadas por el cambio
-- NOTA: Si alguien sabe como pasar por parametro un nombre de tabla y campo a modificarse
-- hara mucho mas sencillito porque solo habra que implementar un funcion ya que siempre
-- hay que hacer lo mismo.
--

--
-- Funcion auxiliar para borrar funciones limpiamente
--
CREATE OR REPLACE FUNCTION drop_if_exists_table (text) RETURNS INTEGER AS '
DECLARE
    tbl_name ALIAS FOR $1;
BEGIN
    IF (select count(*) from pg_tables where tablename=$1) THEN
	EXECUTE ''DROP TABLE '' || $1;
	RETURN 1;
    END IF;
    RETURN 0;
END;
'
language 'plpgsql';


CREATE OR REPLACE FUNCTION drop_if_exists_proc (text, text) RETURNS INTEGER AS '
DECLARE
    proc_name ALIAS FOR $1;
    proc_params ALIAS FOR $2;
BEGIN
    IF (select count(*) from pg_proc where proname=$1) THEN
	EXECUTE ''DROP FUNCTION '' || $1 || ''(''||$2||'') CASCADE'';
	RETURN 1;
    END IF;
    RETURN 0;
END;
'
language 'plpgsql';

-- SELECT drop_if_exists_proc ('calculacodigocompletoarticulo','');

-- ======================== COMPROBACION DE CUAL ES LA ULTIMA VERSION ==================================

CREATE OR REPLACE FUNCTION compruebarevision() RETURNS INTEGER AS '
DECLARE
	as RECORD;
BEGIN
	SELECT INTO as * FROM configuracion WHERE nombre=''DatabaseRevision'' AND ( valor LIKE ''0.10.1%'' OR valor = ''0.9.3-0009'');
	IF FOUND THEN
		RETURN 0;
	ELSE
		RAISE EXCEPTION '' Version de la base de datos invalida, aplique parches anteriores'';
		RETURN -1;		 
	END IF;
END;
'   LANGUAGE plpgsql;
SELECT compruebarevision();
DROP FUNCTION compruebarevision() CASCADE;
\echo "Comprobada la revision"

-- ========================  FIN DE LA COMPROBACION ============================

\echo -n ':: Tabla "cliente" se hace obligatorio y no nulo el campo "nomcliente" ... '
CREATE OR REPLACE FUNCTION aux() RETURNS INTEGER AS '
DECLARE
	bs RECORD;
	cs RECORD;
BEGIN
	SELECT INTO bs * FROM pg_constraint WHERE conname=''cliente_nomcliente_key'';
	IF NOT FOUND THEN
		ALTER TABLE cliente ADD CONSTRAINT cliente_nomcliente_key UNIQUE (nomcliente);
		ALTER TABLE cliente ALTER COLUMN nomcliente SET NOT NULL;
	END IF;
	RETURN 0;
END;
' LANGUAGE plpgsql;
SELECT aux();
DROP FUNCTION aux() CASCADE;


\echo -n ':: Agrega el campo de Tipo de Almacen ... '
CREATE OR REPLACE FUNCTION aux() RETURNS INTEGER AS '
DECLARE
	as RECORD;
BEGIN
	SELECT INTO as * FROM pg_attribute WHERE attname=''tipoalmacen'';
	IF NOT FOUND THEN
		ALTER TABLE almacen ADD COLUMN tipoalmacen varchar;
	END IF;
	RETURN 0;
END;
' LANGUAGE plpgsql;
SELECT aux();
DROP FUNCTION aux() CASCADE;


\echo -n ':: Agrega el campo de Comercio Electronico en la ficha de cliente ... '
CREATE OR REPLACE FUNCTION aux() RETURNS INTEGER AS '
DECLARE
        bs RECORD;
BEGIN
	SELECT INTO bs * FROM pg_attribute WHERE attname=''ecommercedatacliente'';
	IF NOT FOUND THEN
		ALTER TABLE cliente ADD COLUMN ecommercedatacliente CHARACTER VARYING(2000);
	END IF;

	RETURN 0;
END;
' LANGUAGE plpgsql;
SELECT aux();
DROP FUNCTION aux() CASCADE;


\echo -n ':: Reduce la longitud del campo descpedidocliente ... '
CREATE OR REPLACE FUNCTION cambia_longitud(cadena CHARACTER VARYING) RETURNS CHARACTER VARYING AS '
BEGIN
    RETURN substr(cadena, 1, 150);
END
' LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION aux() RETURNS INTEGER AS '
DECLARE
        bs RECORD;
BEGIN
	SELECT INTO bs * FROM pg_attribute WHERE attname=''descpedidocliente'';
	IF FOUND THEN
		ALTER TABLE pedidocliente ALTER COLUMN descpedidocliente TYPE CHARACTER VARYING(150) USING cambia_longitud(descpedidocliente);
	END IF;

	SELECT INTO bs * FROM pg_attribute WHERE attname=''descfactura'';
	IF FOUND THEN
		ALTER TABLE factura ALTER COLUMN descfactura TYPE CHARACTER VARYING(150) USING cambia_longitud(descfactura);
	END IF;

	SELECT INTO bs * FROM pg_attribute WHERE attname=''descpedidoproveedor'';
	IF FOUND THEN
		ALTER TABLE pedidoproveedor ALTER COLUMN descpedidoproveedor TYPE CHARACTER VARYING(150) USING cambia_longitud(descpedidoproveedor);
	END IF;

	SELECT INTO bs * FROM pg_attribute WHERE attname=''descfacturap'';
	IF FOUND THEN
		ALTER TABLE facturap ALTER COLUMN descfacturap TYPE CHARACTER VARYING(150) USING cambia_longitud(descfacturap);
	END IF;

	RETURN 0;
END;
' LANGUAGE plpgsql;
SELECT aux();
DROP FUNCTION aux() CASCADE;
DROP FUNCTION cambia_longitud(CHARACTER VARYING) CASCADE;


-- ================================== ACTUALIZACION  ===================================
-- =====================================================================================

-- Agregamos nuevos parametros de configuracion
--
CREATE OR REPLACE FUNCTION actualizarevision() RETURNS INTEGER AS '
DECLARE
	as RECORD;
BEGIN
	SELECT INTO as * FROM configuracion WHERE nombre = ''DatabaseRevision'';
	IF FOUND THEN
		UPDATE CONFIGURACION SET valor = ''0.10.1-0005'' WHERE nombre = ''DatabaseRevision'';
	ELSE
		INSERT INTO configuracion (nombre, valor) VALUES (''DatabaseRevision'', ''0.10.1-0005'');
	END IF;
	RETURN 0;
END;
'   LANGUAGE plpgsql;
SELECT actualizarevision();
DROP FUNCTION actualizarevision() CASCADE;
\echo "Actualizada la revision de la base de datos a la version 0.10.1"

DROP FUNCTION drop_if_exists_table(text) CASCADE;
DROP FUNCTION drop_if_exists_proc(text, text) CASCADE;


COMMIT;

