#!/usr/bin/env python
from distutils.core import setup

try:
    from extras import cmdclass
except ImportError:
    cmdclass = {}

bzr_plugin_name = 'explorer'

bzr_plugin_version = (1, 0, 0, 'final', 0)
bzr_minimum_version = (1, 13, 0)
bzr_maximum_version = None

if __name__ == '__main__':
    setup(name="explorer",
          version="1.0.0",
          description="desktop application for using Bazaar.",
          author="Canonical Ltd",
          author_email="bazaar@lists.canonical.com",
          license = "GNU GPL v2",
          url="https://launchpad.net/bzr-explorer",
          scripts=[],
          packages=['bzrlib.plugins.explorer',
                    'bzrlib.plugins.explorer.lib',
                    'bzrlib.plugins.explorer.lib.builders',
                    'bzrlib.plugins.explorer.lib.extensions',
                    'bzrlib.plugins.explorer.tests',
                    'bzrlib.plugins.explorer.widgets',
                    ],
          package_data={'bzrlib.plugins.explorer': ['skin/*.conf',
                                                    'skin/*.xml',
                                                    'skin/logos/*.png',
                                                    'clothes/*/icon.png',
                                                    'clothes/*/*.conf',
                                                    'clothes/*/*.xml',
                                                    'clothes/*/logos/*.png',
                                                    'hats/*/icon.png',
                                                    'hats/*/*.conf',
                                                    'hats/*/*.xml',
                                                    'hats/*/logos/*.png',
                                                    'locale/*/LC_MESSAGES/*.mo',
                                                    '*.txt',
                                                    'NEWS',
                                                    '*.ini',
                                                    '*.xml'
                                                   ]},
          package_dir={'bzrlib.plugins.explorer': '.'},
          cmdclass=cmdclass,
          )
