from bzrlib.tests.blackbox import ExternalBase
from unittest import makeSuite
import os.path
class TestBzrTools(ExternalBase):
    @staticmethod
    def touch(filename):
        file(filename, 'wb').write('')

    def test_clean_tree(self):
        self.runbzr('init')
        self.runbzr('ignore *~')
        self.runbzr('ignore *.pyc')
        self.touch('name')
        self.touch('name~')
        assert os.path.lexists('name~')
        self.touch('name.pyc')
        self.runbzr('clean-tree')
        assert os.path.lexists('name~')
        assert not os.path.lexists('name')
        self.touch('name')
        self.runbzr('clean-tree --detritus')
        assert os.path.lexists('name')
        assert not os.path.lexists('name~')
        assert os.path.lexists('name.pyc')
        self.runbzr('clean-tree --ignored')
        assert os.path.lexists('name')
        assert not os.path.lexists('name.pyc')
        self.runbzr('clean-tree --unknown')
        assert not os.path.lexists('name')
        self.touch('name')
        self.touch('name~')
        self.touch('name.pyc')
        self.runbzr('clean-tree --unknown --ignored')
        assert not os.path.lexists('name')
        assert not os.path.lexists('name~')
        assert not os.path.lexists('name.pyc')

    def test_shelve(self):
        self.runbzr('init')
        self.runbzr('commit -m uc --unchanged')
        self.runbzr('shelve -r 1 -m foo --all', retcode=3)
        file('foo', 'wb').write('foo')
        self.runbzr('add foo')
        self.runbzr('commit -m foo')
        self.runbzr('shelve -r 1 -m foo --all', retcode=0)

    def test_fetch_ghosts(self):
        self.runbzr('init')
        self.runbzr('fetch-ghosts .')

    def test_patch(self):
        self.runbzr('init')
        file('myfile', 'wb').write('hello')
        self.runbzr('add')
        self.runbzr('commit -m hello')
        file('myfile', 'wb').write('goodbye')
        file('mypatch', 'wb').write(self.runbzr('diff', retcode=1, backtick=1))
        self.runbzr('revert')
        assert file('myfile', 'rb').read() == 'hello'
        self.runbzr('patch mypatch')
        assert file('myfile', 'rb').read() == 'goodbye'

    def test_branch_history(self):
        self.runbzr('init')
        file('myfile', 'wb').write('hello')
        self.runbzr('add')
        self.runbzr('commit -m hello')
        self.runbzr('branch-history')

    def test_branch_history(self):
        self.runbzr('init')
        file('myfile', 'wb').write('hello')
        self.runbzr('add')
        self.runbzr('commit -m hello')
        self.runbzr('graph-ancestry . graph.dot')
        self.runbzr('branch . my_branch')
        self.runbzr('graph-ancestry . graph.dot --merge-branch my_branch')

    def test_fetch_ghosts(self):
        self.runbzr('init')
        file('myfile', 'wb').write('hello')
        self.runbzr('add')
        self.runbzr('commit -m hello')
        self.runbzr('branch . my_branch')
        self.runbzr('fetch-ghosts my_branch')

    def test_zap(self):
        self.runbzr('init source')
        self.runbzr('checkout --lightweight source checkout')
        self.runbzr('zap checkout')
        self.assertIs(False, os.path.exists('checkout'))
        self.assertIs(True, os.path.exists('source'))

    def test_zap_branch(self):
        self.runbzr('init source')
        self.runbzr('checkout --lightweight source checkout')
        self.runbzr('zap --branch checkout', retcode=3)
        self.assertIs(True, os.path.exists('checkout'))
        self.assertIs(True, os.path.exists('source'))
        self.runbzr('branch source source2')
        self.runbzr('checkout --lightweight source2 checkout2')
        self.runbzr('zap --branch checkout2')
        self.assertIs(False, os.path.exists('checkout2'))
        self.assertIs(False, os.path.exists('source2'))

    def test_branches(self):
        self.runbzr('init source')
        self.runbzr('init source/subsource')
        self.runbzr('checkout --lightweight source checkout')
        self.runbzr('init checkout/subcheckout')
        self.runbzr('init checkout/.bzr/subcheckout')
        out = self.capture('branches')
        lines = out.split('\n')
        self.assertIs(True, 'source' in lines)
        self.assertIs(True, 'source/subsource' in lines)
        self.assertIs(True, 'checkout/subcheckout' in lines)
        self.assertIs(True, 'checkout' not in lines)
        self.assertIs(True, 'checkout/.bzr/subcheckout' not in lines)

    def test_import_upstream(self):
        self.runbzr('init source')
        os.mkdir('source/src')
        f = file('source/src/myfile', 'wb')
        f.write('hello?')
        f.close()
        os.chdir('source')
        self.runbzr('add')
        self.runbzr('commit -m hello')
        self.runbzr('export ../source-0.1.tar.gz')
        self.runbzr('export ../source-0.1.tar.bz2')
        self.runbzr('init ../import')
        os.chdir('../import')
        self.runbzr('import ../source-0.1.tar.gz')
        self.failUnlessExists('src/myfile')
        result = self.runbzr('import ../source-0.1.tar.gz', retcode=3)[1]
        self.assertContainsRe(result, 'Working tree has uncommitted changes')
        self.runbzr('commit -m commit')
        self.runbzr('import ../source-0.1.tar.gz')
        os.chdir('..')
        self.runbzr('init import2')
        self.runbzr('import source-0.1.tar.gz import2')
        self.failUnlessExists('import2/src/myfile')
        self.runbzr('import source-0.1.tar.gz import3')
        self.failUnlessExists('import3/src/myfile')
        self.runbzr('import source-0.1.tar.bz2 import4')
        self.failUnlessExists('import4/src/myfile')

def test_suite():
    return makeSuite(TestBzrTools)
