#include <type_traits>
#include <vector>
#include <string>
#include <iostream>

class NoMove
{
    public:
        NoMove() = default;
        NoMove(NoMove const &) = default;
        NoMove(NoMove &&) = delete;
};


template <typename DataType>
concept bool MoveAndCopyable()
{
    return std::is_copy_constructible<DataType>::value &&
           std::is_move_constructible<DataType>::value &&
           std::is_copy_assignable<DataType>::value &&
           std::is_move_assignable<DataType>::value;
}

template <MoveAndCopyable Data,
          template <MoveAndCopyable> typename Container>
struct Process
{
    Process()
    {
        std::cout << "Constrained\n";
    }

};

//VECTOR
template <typename Data>
using Vector = std::vector<Data>;
//=
//MAIN
int main()
{
    Process<std::string, Vector> proc1;
    Process<NoMove, Vector> proc2;
}
//=
