/**
 * @file c2n.h
 * Interface definitions related to the Commodore C2N storage format
 * @author Marko Mkel (msmakela@nic.funet.fi)
 */

/* Copyright  2001 Marko Mkel.

   This file is part of C2N, a program for processing data tapes in
   Commodore C2N format.

   C2N is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   C2N is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   59 Temple Place, Suite 330, Boston, MA 02111 USA. */

/** Pulse widths */
enum pulse
{
  Pause = 0,	/**< break in the pulse stream */
  Short,	/**< short pulse */
  Medium,	/**< medium pulse */
  Long		/**< long pulse */
};
/** Errors related to the pulse stream */
enum pulse_error
{
  Parity = 4,	/**< error in the parity bit */
  Checksum,	/**< checksum mismatch */
  NoFirst,	/**< first copy of a block is missing */
  NoSecond,	/**< second copy of a block is missing */
  LongBlock,	/**< block too long */
  ShortBlock,	/**< block too short */
  Unexpected,	/**< unexpected header tag */
  Mismatch,	/**< mismatch between first and second copy */
  Countdown	/**< unrecognized header countdown sequence */
};
/** Commodore C2N tape header identifier tags */
enum c2n_tag
{
  tBasic = 1,      /**< relocatable (BASIC) program */
  tDataBlock = 2,  /**< actual data block of a data file */
  tML = 3,         /**< absolute program */
  tDataHeader = 4, /**< data file header */
  tEnd = 5         /**< end-of-tape header */
};

/** Pulse stream reader
 * @return	a pulse from the stream, or Pause at end of stream
 */
typedef enum pulse (*pulse_r_t) (void);
/** Pulse stream writer
 * @param p	the pulse to be written
 */
typedef void (*pulse_w_t) (enum pulse p);

/** Error reporter
 * @param pe	the unexpected pulse or error code
 * @param block	the block in which the error occurred (0=first header)
 * @param pos	number of bytes decoded from the stream
 * @return	nonzero on fatal error
 */
typedef unsigned (*pulse_error_t) (unsigned pe, unsigned block, unsigned pos);

/** Flag: verbose mode */
extern unsigned verbose;
