(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

open Zog_types

(** Icons used in Zoggy graphical interface. *)

let arrow = [|
"21 21 5 1";
"  c Gray0";
". c #d6d6d6";
"X c #b3cece";
"o c Gray100";
"O c None";
"OOOOOOOOOOOOOOOOOOOOO";
"OOOOOOOOOOOOOOOOOOOOO";
"OOOOOOOOOOOOOOOOOOOOO";
"OOOOOOOOOOOOOOOOOOOOO";
"OOOooOOOOOOOOOOOOOOOO";
"OOOo.ooOOOOOOOOOOOOOO";
"OOOo...ooOOOOOOOOOOOO";
"OOOo.....ooOOOOOOOOOO";
"OOOo.......ooOOOOOOOO";
"OOOo.........ooOOOOOO";
"OOOo...........  OOOO";
"OOOo.........  OOOOOO";
"OOOo.......  OOOOOOOO";
"OOOo.....  OOOOOOOOOO";
"OOOo...  OOOOOOOOOOOO";
"OOOo.  OOOOOOOOOOOOOO";
"OOOo OOOOOOOOOOOOOOOO";
"OOOOOOOOOOOOOOOOOOOOO";
"OOOOOOOOOOOOOOOOOOOOO";
"OOOOOOOOOOOOOOOOOOOOO";
"OOOOOOOOOOOOOOOOOOOOO"
|] 

let aspect_frame = [|
"21 21 6 1" ;
"  c Gray0" ;
". c #7b7b7b" ;
"X c #d6d6d6" ;
"o c #b3cece" ;
"O c Gray100" ;
"+ c None" ;
"+++++++++++++++++++++" ;
"+++++   + +++++++++++" ;
"+...X X X   X......O+" ;
"+.OOX   X X XOOOOO.O+" ;
"+.OXX X X   XXXXXX.O+" ;
"+.OXXXXXXXXXXXXXXX.O+" ;
"+.OXXXXXXX.XXXXXXX.O+" ;
"+.OXXXXXX...XXXXXX.O+" ;
"+.OXXXXX.X.X.XXXXX.O+" ;
"+.OXXXXXXX.XXXXXXX.O+" ;
"+.OXX.XXXX.XXXX.XX.O+" ;
"+.OX.XXXXX.XXXXX.X.O+" ;
"+.O................O+" ;
"+.OX.XXXXX.XXXXX.X.O+" ;
"+.OXX.XXXX.XXXX.XX.O+" ;
"+.OXXXXX.X.X.XXXXX.O+" ;
"+.OXXXXXX...XXXXXX.O+" ;
"+.OXXXXXXX.XXXXXXX.O+" ;
"+..................O+" ;
"+OOOOOOOOOOOOOOOOOOO+" ;
"+++++++++++++++++++++"
|]

let button = [|
"21 21 6 1" ;
"  c Gray0" ;
". c #7b7b7b" ;
"X c #d6d6d6" ;
"o c #b3cece" ;
"O c Gray100" ;
"+ c None" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+OOOOOOOOOOOOOOOOOO +" ;
"+OXXXXXXXXXXXXXXXX. +" ;
"+OXXXXXXXXXXXXXXXX. +" ;
"+OXXX   XXX XXX XX. +" ;
"+OXX XXX XX XX XXX. +" ;
"+OXX XXX XX X XXXX. +" ;
"+OXX XXX XX  XXXXX. +" ;
"+OXX XXX XX X XXXX. +" ;
"+OXX XXX XX XX XXX. +" ;
"+OXXX   XXX XXX XX. +" ;
"+OXXXXXXXXXXXXXXXX. +" ;
"+OXXXXXXXXXXXXXXXX. +" ;
"+OXXXXXXXXXXXXXXXX. +" ;
"+O................. +" ;
"+                   +" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++"
|]

let calendar = [|
"21 21 5 1";
"       c None";
".      c #000000";
"+      c #DEDEDE";
"@      c #FFFFFF";
"#      c #DFDFDF";
"                     ";
".....................";
".+++++++++++++++++++.";
".+..+..+..+..+..+..+.";
".+++++++++++++++++++.";
".....................";
".@@@@@@@@@@@@@@@@@@@.";
".@@+@@.@@.@@.@@.@@.@.";
".@@@@@@@@@@@@@@@@@@@.";
".@@.@@.@@.@@.@@.@@.@.";
".@@@@@@@@@@@@@@@@@@@.";
".@@.@@.@@.@@.@@.@@.@.";
".@@@@@@@@@@@@@@@@@@@.";
".@@.@@.@@.@@.@@.@@.@.";
".@@@@@@@@@@@@@@@@@@@.";
".@@.@@.@@.@@+@@+@@+@.";
".@@@@@@@@@@@@@@@@@@@.";
".@@+@@+@@+@@+@@+@@#@.";
".@@@@@@@@@@@@@@@@@@@.";
".....................";
"                     "
|] 

let check_button = [|
"21 21 6 1" ;
"  c Gray0" ;
". c #7b7b7b" ;
"X c #d6d6d6" ;
"o c #b3cece" ;
"O c Gray100" ;
"+ c None" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++OOOOOOOOOOO+++++" ;
"+++++OXXXXXXXXX +++++" ;
"+++++OXXXXXXXX. +++++" ;
"+++++OXXXXXXXX. +++++" ;
"+++++OXXXXXXXX. +++++" ;
"+++++OXXXXXXXX. +++++" ;
"+++++OXXXXXXXX. +++++" ;
"+++++OXXXXXXXX. +++++" ;
"+++++OXXXXXXXX. +++++" ;
"+++++OX........ +++++" ;
"+++++O          +++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++"
|]

let check_menu_item = [|
"21 21 4 1";
"       c None";
".      c #FFFFFF";
"+      c #7B7B7B";
"@      c #000000";
"                     ";
"                     ";
"                     ";
"                     ";
"                     ";
"                     ";
"                     ";
"  ........           ";
"  .     +@           ";
"  .     +@           ";
"  .     +@           ";
"  .     +@       @   ";
"  . +++++@     @@    ";
"  .@@@@@@@   @@@@    ";
"           @@@@@     ";
"            @@@@     ";
"            @@@      ";
"           @  @      ";
"          @          ";
"         @           ";
"                     "
|] 

let clist = [|
"21 21 3 1" ;
"  c Gray0" ;
". c Gray87" ;
"X c Gray100" ;
"                     " ;
" ...... ...... ..... " ;
" ...... ...... ..... " ;
" ...... ...... ..... " ;
"                     " ;
" XXXXXX XXXXXX XXXXX " ;
" XXXXXX XXXXXX XXXXX " ;
" XXXXXX XXXXXX XXXXX " ;
"                     " ;
" XXXXXX XXXXXX XXXXX " ;
" XXXXXX XXXXXX XXXXX " ;
" XXXXXX XXXXXX XXXXX " ;
"                     " ;
" XXXXXX XXXXXX XXXXX " ;
" XXXXXX XXXXXX XXXXX " ;
" XXXXXX XXXXXX XXXXX " ;
"                     " ;
" XXXXXX XXXXXX XXXXX " ;
" XXXXXX XXXXXX XXXXX " ;
" XXXXXX XXXXXX XXXXX " ;
"                     "
|]

let color_selection = [|
"21 21 8 1" ;
"  c Gray0" ;
". c #7b7b7b" ;
"X c Blue" ;
"o c Green" ;
"O c Red" ;
"+ c #b3cece" ;
"@ c Gray100" ;
"# c None" ;
"#####################" ;
"#####################" ;
"#####################" ;
"#####################" ;
"#####################" ;
"##................###" ;
"##.@@@@@@@@@@@@@@. ##" ;
"##.@@@@@@@@@@@@@@. ##" ;
"##.@@@@@@@@@@@@@@. ##" ;
"##.@@OOOoooXXX@@@. ##" ;
"##.@@OOOoooXXX@@@. ##" ;
"##.@@OOOoooXXX@@@. ##" ;
"##.@@OOOoooXXX@@@. ##" ;
"##.@@@@@@@@@@@@@@. ##" ;
"##.@@@@@@@@@@@@@@. ##" ;
"##.@@@@@@@@@@@@@@. ##" ;
"##................ ##" ;
"###                ##" ;
"#####################" ;
"#####################" ;
"#####################"
|]

let combo = [|
"21 21 7 1" ;
"  c Gray0" ;
". c #7b7b7b" ;
"X c #d6d6d6" ;
"o c #b3cece" ;
"O c Gray87" ;
"+ c Gray100" ;
"@ c None" ;
"@@@@@@@@@@@@@@@@@@@@@" ;
"                     " ;
" +++++++++++++ OOOOO " ;
" +++++++++++++  OOO  " ;
" +++++++++++++   O   " ;
"                     " ;
" +++++++++++++ ++++++" ;
" +++++++++++++ XXXXX " ;
" +.........+++ XX XX " ;
" +++++++++++++ X   X " ;
" +++++++++++++ XXXXX " ;
" +...........+       " ;
" +++++++++++++ +++++ " ;
" +++++++++++++ +XXXX " ;
" +..........++ ..... " ;
" +++++++++++++ +++++ " ;
" +++++++++++++ XXXXX " ;
" +...........+ X   X " ;
" +++++++++++++ XX XX " ;
" +++++++++++++ XXXXX " ;
"                     "
|]

let custom = [|
"21 21 6 1";
"       c None";
".      c #FFFFFF";
"+      c #000000";
"@      c #D6D6D6";
"#      c #7B7B7B";
"$      c #0000FF";
"                     ";
"                     ";
"  ................+  ";
"  .@@@@@@@@@@@@@@#+  ";
"  .@@@@@@@@@@@@@@#+  ";
"  .@@@@@$$$$@@@@@#+  ";
"  .@@@@$$$$$$@@@@#+  ";
"  .@@@$$$@@@$$@@@#+  ";
"  .@@@$$@@@@@$@@@#+  ";
"  .@@@$$@@@@@@@@@#+  ";
"  .@@@$$@@@@@@@@@#+  ";
"  .@@@$$@@@@@$@@@#+  ";
"  .@@@$$$@@@$$@@@#+  ";
"  .@@@@$$$$$$@@@@#+  ";
"  .@@@@@$$$$@@@@@#+  ";
"  .@@@@@@@@@@@@@@#+  ";
"  .@@@@@@@@@@@@@@#+  ";
"  .###############+  ";
"  +++++++++++++++++  ";
"                     ";
"                     "
|] 

let drawing_area = [|
"21 21 6 1";
"  c Gray0";
". c Blue";
"X c Red";
"o c Yellow";
"O c #b3cece";
"+ c None";
"+++++++++++++++++++++";
"+++++++++++++++++++++";
"+++++++++++++++++++++";
"++          +++++++++";
"++ XXXXXXXX +++++++++";
"++ XXXXXXXX     +++++";
"++ XXXXXXX ooooo ++++";
"++ XXXXXX ooooooo +++";
"++ XXXXX ooooooooo ++";
"++ XXXXX ooooooooo ++";
"++ XXXXX ooooooooo ++";
"++ XXXXX ooooooooo ++";
"++        ooooooo +++";
"++++ ..... ooooo ++++";
"++++ ......     +++++";
"++++ ......... ++++++";
"++++ ......... ++++++";
"++++ ......... ++++++";
"++++           ++++++";
"+++++++++++++++++++++";
"+++++++++++++++++++++"
|] 

let entry = [|
"21 21 6 1" ;
"  c Gray0" ;
". c #7b7b7b" ;
"X c #d6d6d6" ;
"o c #b3cece" ;
"O c Gray100" ;
"+ c None" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"....................O" ;
".                  XO" ;
". OOOOOOOOOOOOOOOOOXO" ;
". OOOOOOOOOOOOOOO OXO" ;
". OOOOOOOO OOOOOO OXO" ;
". OOOOOOOO OOOOOO OXO" ;
". OOO   OO X  OOO OXO" ;
". OO XOX O  O. OO OXO" ;
". OOOOOO O OOO OO OXO" ;
". OOO    O OOO OO OXO" ;
". OO XOO O OOO OO OXO" ;
". OO XOO O OO. OO OXO" ;
". OOO    O    OOO OXO" ;
". OOOOOOOOOOOOOOO OXO" ;
". OOOOOOOOOOOOOOOOOXO" ;
".XXXXXXXXXXXXXXXXXXXO" ;
"OOOOOOOOOOOOOOOOOOOOO" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++"
|]

let event_box = [|
"21 21 7 1" ;
"  c Gray0" ;
". c #7b7b7b" ;
"X c Blue" ;
"o c #d6d6d6" ;
"O c #b3cece" ;
"+ c Gray100" ;
"@ c None" ;
"@@@@@@@@@@X+@@@@@@@@@" ;
"@@@@@@@@@XX+@@@@@@@@@" ;
"@@@@@@@@XX+@@@@@@@@@@" ;
"@@@@@@@XX+@@@@@@@@@@@" ;
"@@@@@@@@XX+@@@@@@@@@@" ;
"@@@@@@@@@XX+@@@@@@@@@" ;
"@@@@@@@@@@XX+@@@@@@@@" ;
"@@@++++++XX++++++ @@@" ;
"@@@+ooooXX+ooooo. @@@" ;
"@@@+oooXX+oooooo. @@@" ;
"@@@+ooooXX+ooooo. @@@" ;
"@@@+oooooXX+oooo. @@@" ;
"@@@+ooooooXX+ooo. @@@" ;
"@@@+oooooooooooo. @@@" ;
"@@@+oooooooooooo. @@@" ;
"@@@+oooooooooooo. @@@" ;
"@@@+............. @@@" ;
"@@@               @@@" ;
"@@@@@@@@@@@@@@@@@@@@@" ;
"@@@@@@@@@@@@@@@@@@@@@" ;
"@@@@@@@@@@@@@@@@@@@@@"
|]

let fixed = [|
"21 21 4 1" ;
"  c Gray0" ;
". c #7b7b7b" ;
"X c #d6d6d6" ;
"o c Gray100" ;
"oooooooooooooooooooo " ;
"oXXXXXXXXXXXXXXXXXX. " ;
"oXXXXXXXXXXXXXXXXXX. " ;
"oXooooo XXXXXXXXXXX. " ;
"oXoXXX. XXXXXXXXXXX. " ;
"oXoXXX. XXXXooooo X. " ;
"oXo.... XXXXoXXX. X. " ;
"oX      XXXXoXXX. X. " ;
"oXXXXXXXXXXXo.... X. " ;
"oXXXXXXXXXXX      X. " ;
"oXXXXXXXXXXXXXXXXXX. " ;
"oXXXXooooo XXXXXXXX. " ;
"oXXXXoXXX. XXXXXXXX. " ;
"oXXXXoXXX. XXXXXXXX. " ;
"oXXXXo.... XXXXXXXX. " ;
"oXXXX      XXXXXXXX. " ;
"oXXXXXXXXXXXXXXXXXX. " ;
"oXXXXXXXXXXXXXXXXXX. " ;
"oXXXXXXXXXXXXXXXXXX. " ;
"o................... " ;
"                     "
|]

let font_selection = [|
"21 21 8 1";
"  c Gray0";
". c #7b7b7b";
"X c Gray61";
"o c #d6d6d6";
"O c #b3cece";
"+ c Gray87";
"@ c Gray100";
"# c None";
"#####################";
"#####################";
"#####################";
"#####################";
"#####################";
"##................###";
"##.@@@@@@@@@@@@@@. ##";
"##.@@@@@@@@@@@@@@. ##";
"##.@@@@@@@X  o@@@. ##";
"##.@@@@@@+  @X@@@. ##";
"##.@@@@@   @@@@@@. ##";
"##.@@@@@@   @@@@@. ##";
"##.@@@ +  @@@@@@@. ##";
"##.@@@o  X@@@@@@@. ##";
"##.@@@@@@@@@@@@@@. ##";
"##.@@@@@@@@@@@@@@. ##";
"##................ ##";
"###                ##";
"#####################";
"#####################";
"#####################"
|] 

let frame = [|
"21 21 6 1" ;
"  c Gray0" ;
". c #7b7b7b" ;
"X c #d6d6d6" ;
"o c #b3cece" ;
"O c Gray100" ;
"+ c None" ;
"+++++++++++++++++++++" ;
"+++++   + +++++++++++" ;
"+...X X X   X......O+" ;
"+.OOX   X X XOOOOO.O+" ;
"+.OXX X X   XXXXXX.O+" ;
"+.OXXXXXXXXXXXXXXX.O+" ;
"+.OXXXXXXXXXXXXXXX.O+" ;
"+.OXXXXXXXXXXXXXXX.O+" ;
"+.OXXXXXXXXXXXXXXX.O+" ;
"+.OXXXXXXXXXXXXXXX.O+" ;
"+.OXXXXXXXXXXXXXXX.O+" ;
"+.OXXXXXXXXXXXXXXX.O+" ;
"+.OXXXXXXXXXXXXXXX.O+" ;
"+.OXXXXXXXXXXXXXXX.O+" ;
"+.OXXXXXXXXXXXXXXX.O+" ;
"+.OXXXXXXXXXXXXXXX.O+" ;
"+.OXXXXXXXXXXXXXXX.O+" ;
"+.OXXXXXXXXXXXXXXX.O+" ;
"+..................O+" ;
"+OOOOOOOOOOOOOOOOOOO+" ;
"+++++++++++++++++++++"
|]

let handle_box = [|
"21 21 7 1" ;
"  c Gray0" ;
". c #7b7b7b" ;
"X c #d6d6d6" ;
"o c #b3cece" ;
"O c Gray87" ;
"+ c Gray100" ;
"@ c None" ;
"@@@@@@@@@@@@@@@@@@@@@" ;
"@@@@@@@@@@@@@@@@@@@@@" ;
"@@@@@@@@@@@@@@@@@@@@@" ;
"@++++++++++++++++++ @" ;
"@+OOOO.XXXXXXXXXXX. @" ;
"@++OOO.XXXXXXXXXXX. @" ;
"@+O.+O.XXXXXXXXXXX. @" ;
"@+OOO..XXXXXXXXXXX. @" ;
"@++OOO.XXXXXXXXXXX. @" ;
"@+O.+O.XXXXXXXXXXX. @" ;
"@+OOO..XXXXXXXXXXX. @" ;
"@++OOO.XXXXXXXXXXX. @" ;
"@+O.+O.XXXXXXXXXXX. @" ;
"@+OOO..XXXXXXXXXXX. @" ;
"@+................. @" ;
"@                   @" ;
"@@@@@@@@@@@@@@@@@@@@@" ;
"@@@@@@@@@@@@@@@@@@@@@" ;
"@@@@@@@@@@@@@@@@@@@@@" ;
"@@@@@@@@@@@@@@@@@@@@@" ;
"@@@@@@@@@@@@@@@@@@@@@"
|]

let hbox = [|
"21 21 4 1" ;
"  c Gray0" ;
". c #7b7b7b" ;
"X c #d6d6d6" ;
"o c Gray100" ;
"oooooo oooooo oooooo " ;
"oXXXX. oXXXX. oXXXX. " ;
"oXXXX. oXXXX. oXXXX. " ;
"oXXXX. oXXXX. oXXXX. " ;
"oXXXX. oXXXX. oXXXX. " ;
"oXXXX. oXXXX. oXXXX. " ;
"oXXXX. oXXXX. oXXXX. " ;
"oXXXX. oXXXX. oXXXX. " ;
"oXXXX. oXXXX. oXXXX. " ;
"oXXXX. oXXXX. oXXXX. " ;
"oXXXX. oXXXX. oXXXX. " ;
"oXXXX. oXXXX. oXXXX. " ;
"oXXXX. oXXXX. oXXXX. " ;
"oXXXX. oXXXX. oXXXX. " ;
"oXXXX. oXXXX. oXXXX. " ;
"oXXXX. oXXXX. oXXXX. " ;
"oXXXX. oXXXX. oXXXX. " ;
"oXXXX. oXXXX. oXXXX. " ;
"oXXXX. oXXXX. oXXXX. " ;
"o..... o..... o..... " ;
"                     "
|]

let hbutton_box = [|
"21 21 6 1" ;
"  c Gray0" ;
". c #7b7b7b" ;
"X c #d6d6d6" ;
"o c #b3cece" ;
"O c Gray100" ;
"+ c None" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+OOOOO +OOOOO +OOOOO " ;
"+OXXX. +OXXX. +OXXX. " ;
"+OXXX. +OXXX. +OXXX. " ;
"+O.... +O.... +O.... " ;
"+      +      +      " ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++"
|]

let hpaned = [|
"21 21 4 1";
"  c Gray0";
". c #7b7b7b";
"X c #d6d6d6";
"o c Gray100";
"oooooooooo ooooooooo ";
"oXXXXXXXX. oXXXXXXX. ";
"oXXXXXXXX. oXXXXXXX. ";
"oXXXXXXXX. oXXXXXXX. ";
"oXXXXXXXX. oXXXXXXX. ";
"oXXXXXXXX. oXXXXXXX. ";
"oXXXXXXXX. oXXXXXXX. ";
"oXXXXXXXX. oXXXXXXX. ";
"oXXXXXXXX. oXXXXXXX. ";
"oXXXXXXXX. oXXXXXXX. ";
"oXXXXXXXX. oXXXXXXX. ";
"oXXXXXXXX. oXXXXXXX. ";
"oXXXXXX.....XXXXXXX. ";
"oXXXXXX.ooo..XXXXXX. ";
"oXXXXXX.ooo..XXXXXX. ";
"oXXXXXX.ooo..XXXXXX. ";
"oXXXXXX......XXXXXX. ";
"oXXXXXXX.....XXXXXX. ";
"oXXXXXXXX. oXXXXXXX. ";
"o......... o........ ";
"                     "
|]

let hruler = [|
"21 21 3 1";
"  c Gray0";
". c #b3cece";
"X c None";
"XXXXXXXXXXXXXXXXXXXXX";
"XXXXXXXXXXXXXXXXXXXXX";
"XXXXXXXXXXXXXXXXXXXXX";
"XXXXXXXXXXXXXXXXXXXXX";
"   XXXXXXXXXXXXXXX   ";
" X XXXXXXXXXXXXXXX XX";
" X XXXXXXXXXXXXXXX   ";
" X XXXXXXXXXXXXXXXXX ";
"   XXXXXXXXXXXXXXX   ";
"XXXXXXXXXXXXXXXXXXXXX";
"X XXXXXXXXXXXXXXXXX X";
"X XXXXXXXXXXXXXXXXX X";
"X XXXXX XXXXX XXXXX X";
"X XXXXX XXXXX XXXXX X";
"X XX XX XX XX XX XX X";
"X XX XX XX XX XX XX X";
"X XX XX XX XX XX XX X";
"X                   X";
"XXXXXXXXXXXXXXXXXXXXX";
"XXXXXXXXXXXXXXXXXXXXX";
"XXXXXXXXXXXXXXXXXXXXX"
|] 

let hseparator = [|
"21 21 4 1" ;
"  c #7b7b7b" ;
". c #b3cece" ;
"X c Gray100" ;
"o c None" ;
"ooooooooooooooooooooo" ;
"ooooooooooooooooooooo" ;
"ooooooooooooooooooooo" ;
"ooooooooooooooooooooo" ;
"ooooooooooooooooooooo" ;
"ooooooooooooooooooooo" ;
"ooooooooooooooooooooo" ;
"ooooooooooooooooooooo" ;
"ooooooooooooooooooooo" ;
"ooooooooooooooooooooo" ;
"o                   o" ;
"oXXXXXXXXXXXXXXXXXXXo" ;
"ooooooooooooooooooooo" ;
"ooooooooooooooooooooo" ;
"ooooooooooooooooooooo" ;
"ooooooooooooooooooooo" ;
"ooooooooooooooooooooo" ;
"ooooooooooooooooooooo" ;
"ooooooooooooooooooooo" ;
"ooooooooooooooooooooo" ;
"ooooooooooooooooooooo"
|]

let label = [|
"21 21 3 1" ;
"  c Gray0" ;
". c #b3cece" ;
"X c None" ;
"XXXXXXXXXXXXXXXXXXXXX" ;
"XXXXXXXXXXXXXXXXXXXXX" ;
"XXXXXXXXXXXXXXXXXXXXX" ;
"XXXXXXXXXX  XXXXXXXXX" ;
"XXXXXXXXX   XXXXXXXXX" ;
"XXXXXXXXX   XXXXXXXXX" ;
"XXXXXXXX     XXXXXXXX" ;
"XXXXXXXX     XXXXXXXX" ;
"XXXXXXXX      XXXXXXX" ;
"XXXXXXX  X    XXXXXXX" ;
"XXXXXXX  X     XXXXXX" ;
"XXXXXX  XX     XXXXXX" ;
"XXXXXX          XXXXX" ;
"XXXXX           XXXXX" ;
"XXXXX  XXXXX    XXXXX" ;
"XXXX   XXXXX     XXXX" ;
"XXX    XXXXX      XXX" ;
"XXX     XXX       XXX" ;
"XXXXXXXXXXXXXXXXXXXXX" ;
"XXXXXXXXXXXXXXXXXXXXX" ;
"XXXXXXXXXXXXXXXXXXXXX"
|]

let menu = [|
"21 21 5 1";
"  c Gray0";
". c #7b7b7b";
"X c #b3cece";
"o c Gray100";
"O c None";
"OOOOOOOOOOOOOOOOOOOOO";
"OO........OOOOOOOOOOO";
"OO.oooooo  OOOOOOOOOO";
"OO.ooooo........OOOOO";
"OO.ooooo.oooooo. OOOO";
"OO.......oooooo. OOOO";
"OO.ooooo.oooooo. O.OO";
"OO.ooooo........ O.OO";
"OO.ooooo.oooooo. O.O.";
"OO.......oooooo. O.O.";
"OO.ooooo.oooooo. O.O.";
"OO.ooooo........ O.O.";
"OO.ooooo.        O.O.";
"OO........ O.OOOOO.O.";
"OO.oooooo. O.O.....O.";
"OO.oooooo. O.O.OOOOO.";
"OO.oooooo. O.O.O.....";
"OO........ O.O.OOOOOO";
"OOO        O.O.OOOOOO";
"OOOOOOOOOOOO.O.OOOOOO";
"OOOOO........O.OOOOOO"
|]

let menubar = [|
"21 21 7 1";
"  c Gray0";
". c #7b7b7b";
"X c #d6d6d6";
"o c #b3cece";
"O c Gray87";
"+ c Gray100";
"@ c None";
"@@@@@@@@@@@@@@@@@@@@@";
"@@@@@@@@@@@@@@@@@@@@@";
"@+++++++++++++++++++ ";
"@+XXXXXXXXXXXXXXXXX. ";
"@+XOOOO.OOOO.OOOO.X. ";
"@+XOXXX.OXXX.OXXX.X. ";
"@+XOXXX.OXXX.OXXX.X. ";
"@+X+++++++...O....X. ";
"@+X+OOOOOO.XXXXXXXX. ";
"@+.+O....O.......... ";
"@  +OOOOOO.          ";
"@@@+O....O. @@@@@@@@@";
"@@@+OOOOOO. @@@@@@@@@";
"@@@+O....O. @@@@@@@@@";
"@@@+OOOOOO. @@@@@@@@@";
"@@@+O....O. @@@@@@@@@";
"@@@+OOOOOO. @@@@@@@@@";
"@@@+....... @@@@@@@@@";
"@@@@        @@@@@@@@@";
"@@@@@@@@@@@@@@@@@@@@@";
"@@@@@@@@@@@@@@@@@@@@@"
|] 

let menu_item = [|
"21 21 2 1";
"       c None";
".      c #000000";
"                     ";
"                     ";
"                     ";
"                     ";
"                     ";
"                     ";
"                     ";
"             .       ";
"           ..        ";
"         ....        ";
"       .....         ";
"        ....         ";
"        ...          ";
"       .  .          ";
"      .              ";
"                     ";
"                     ";
"                     ";
"                     ";
"                     ";
"                     "
|] 

let notebook = [|
"21 21 6 1" ;
"  c Gray0" ;
". c #7b7b7b" ;
"X c #d6d6d6" ;
"o c #b3cece" ;
"O c Gray100" ;
"+ c None" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+OOOOOO.OOOO.OOOO.+++" ;
"+OXXXXX.X.X..X.X..+++" ;
"+OXXXXX..X.X..X.X.+++" ;
"+OXXXXX.X.X..X.X..+++" ;
"+OXXXXX.OOOOOOOOOOO +" ;
"+OXXXXXXXXXXXXXXXX. +" ;
"+OXXXXXXXXXXXXXXXX. +" ;
"+OXXXXXXXXXXXXXXXX. +" ;
"+OXXXXXXXXXXXXXXXX. +" ;
"+OXXXXXXXXXXXXXXXX. +" ;
"+OXXXXXXXXXXXXXXXX. +" ;
"+OXXXXXXXXXXXXXXXX. +" ;
"+OXXXXXXXXXXXXXXXX. +" ;
"+O................. +" ;
"+                   +" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++"
|]

let pixmap = [|
"21 21 12 1" ;
"  c Gray0" ;
". c #007b00" ;
"X c #7b7b7b" ;
"o c Blue" ;
"O c Green" ;
"+ c Cyan" ;
"@ c Yellow" ;
"# c #d6d6d6" ;
"$ c #b3cece" ;
"% c Gray87" ;
"& c Gray100" ;
"* c None" ;
"*********************" ;
"*********************" ;
"*********************" ;
"*                    " ;
"* +++++%%%&+++++++++ " ;
"* +&&&++%%++&+++XX++ " ;
"* +++++++%+++++X@@X+ " ;
"* ++&&++++XX+++X@@X+ " ;
"* +++++++ XXX&++XX++ " ;
"* &+++++XXXXXX++++&+ " ;
"* +++++        +++++ " ;
"* +++++ ###### +++++ " ;
"* +++++ #o##o# +++++ " ;
"* ..... ###### ..... " ;
"* OOOOO ##oo## OOOOO " ;
"* OOOOO ##oo## OOOOO " ;
"* OOOOO        OOOOO " ;
"* OOOOOOOOOOOOOOOOOO " ;
"*                    " ;
"*********************" ;
"*********************"
|]

let progress_bar = [|
"21 21 7 1";
"  c Gray0";
". c #7b7b7b";
"X c #d6d6d6";
"o c #b3cece";
"O c Gray87";
"+ c Gray100";
"@ c None";
"@@@@@@@@@@@@@@@@@@@@@";
"@@@@@@@@@@@@@@@@@@@@@";
"@@@@@@@@@@@@@@@@@@@@@";
"@@@@@@@@@@@@@@@@@@@@@";
"@@@@@@@@@@@@@@@@@@@@@";
"@@@@@@@@@@@@@@@@@@@@@";
"@@..................@";
"@@.++++++. XXXXXXXX+@";
"@@.+OOOOO. XXXXXXXX+@";
"@@.+OOOOO. XXXXXXXX+@";
"@@.+OOOOO. XXXXXXXX+@";
"@@.+OOOOO. XXXXXXXX+@";
"@@.+OOOOO. XXXXXXXX+@";
"@@........ XXXXXXXX+@";
"@@.        XXXXXXXX+@";
"@@++++++++++++++++++@";
"@@@@@@@@@@@@@@@@@@@@@";
"@@@@@@@@@@@@@@@@@@@@@";
"@@@@@@@@@@@@@@@@@@@@@";
"@@@@@@@@@@@@@@@@@@@@@";
"@@@@@@@@@@@@@@@@@@@@@"
|] 

let radio_button = [|
"21 21 6 1" ;
"  c Gray0" ;
". c #7b7b7b" ;
"X c #d6d6d6" ;
"o c #b3cece" ;
"O c Gray100" ;
"+ c None" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"++++++++++.++++++++++" ;
"+++++++++...+++++++++" ;
"++++++++.. ..++++++++" ;
"+++++++.. X ..+++++++" ;
"++++++.. XXX ..++++++" ;
"+++++.. XXXXX ..+++++" ;
"++++++OOXXXXXOO++++++" ;
"+++++++OOXXXOO+++++++" ;
"++++++++OOXOO++++++++" ;
"+++++++++OOO+++++++++" ;
"++++++++++O++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++"
|]

let radio_menu_item = [|
"21 21 4 1";
"       c None";
".      c #7B7B7B";
"+      c #000000";
"@      c #FFFFFF";
"                     ";
"                     ";
"                     ";
"                     ";
"       .             ";
"      ...            ";
"     ..+..           ";
"    ..+ +..          ";
"   ..+   +..         ";
"  ..+     +..        ";
"   @@     @@         ";
"    @@   @@          ";
"     @@ @@       +   ";
"      @@@      ++    ";
"       @     ++++    ";
"           +++++     ";
"            ++++     ";
"            +++      ";
"           +  +      ";
"          +          ";
"                     "
|] 

let scrolled_window = [|
"21 21 3 1" ;
"  c Gray0" ;
". c #d6d6d6" ;
"X c Gray100" ;
"XXXXXXXXXXXXXXXXXXXXX" ;
"X.............X..... " ;
"X.............X.. .. " ;
"X.............X.   . " ;
"X.............X..... " ;
"X.............X      " ;
"X.............XXXXXX " ;
"X.............XX.... " ;
"X.............XX.... " ;
"X.............XXXXXX " ;
"X.............X..... " ;
"X.............X.   . " ;
"X.............X.. .. " ;
"X.............X..... " ;
"XXXXXXXXXXXXXXX      " ;
"X.... XXX .... ......" ;
"X.. . X.. . .. ......" ;
"X.  . X.. .  . ......" ;
"X.. . X.. . .. ......" ;
"X.... X.. .... ......" ;
"X              ......"
|]

let spin_button = [|
"21 21 6 1" ;
"  c Gray0" ;
". c #7b7b7b" ;
"X c #d6d6d6" ;
"o c #b3cece" ;
"O c Gray100" ;
"+ c None" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+                   +" ;
"+ OOOOOOOOOOO OOOOO +" ;
"+ OOOOOOOOOOO OX X. +" ;
"+ OOOOOOOOOOO O   . +" ;
"+ OOOOOOOOOOO OOOOO +" ;
"+ OOOOOOOOOOO O   . +" ;
"+ OOOOOOOOOOO OX X. +" ;
"+ OOOOOOOOOOO ..... +" ;
"+                   +" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++"
|]

let statusbar = [|
"21 21 7 1" ;
"  c Gray0" ;
". c #7b7b7b" ;
"X c #d6d6d6" ;
"o c #b3cece" ;
"O c Gray87" ;
"+ c Gray100" ;
"@ c None" ;
"@@@@@@@@@@@@@@@@@@@@@" ;
"@@@@@@@@@@@@@@@@@@@@@" ;
"@@@@@@@@@@@@@@@@@@@@@" ;
"@@@@@@@@@@@@@@@@@@@@@" ;
"@@@+XX.@@@@@@@@@@@@@@" ;
"@@@+XX.@@@@@@@@@@@@@@" ;
"@@@+XX.@@@@@@@@@@@@@@" ;
"@@@+XX.@@@@@@@@@@@@@@" ;
"@@@+XX++++++++++++@@@" ;
"@@@+XXXXXXXXXXXXXX@@@" ;
"@@@+XXXXXXXXXXXXXX@@@" ;
"@@@+XX............@@@" ;
"@@@+XX.OOOOOOOOOOO@@@" ;
"@@@+XX.OOOOOOOOOOO@@@" ;
"@@@+XX.OOOOOOOOOOO@@@" ;
"@@@+XX++++++++++++@@@" ;
"@@@+XXXXXXXXXXXXXX@@@" ;
"@@@+XXXXXXXXXXXXXX@@@" ;
"@@@               @@@" ;
"@@@@@@@@@@@@@@@@@@@@@" ;
"@@@@@@@@@@@@@@@@@@@@@"
|]

let table = [|
"21 21 4 1";
"  c Gray0";
". c #7b7b7b";
"X c #d6d6d6";
"o c Gray100";
"oooooooooo ooooooooo ";
"oXXXXXXXX. oXXXXXXX. ";
"oXXXXXXXX. oXXXXXXX. ";
"oXXXXXXXX. oXXXXXXX. ";
"oXXXXXXXX. oXXXXXXX. ";
"o......... o........ ";
"                     ";
"oooooooooo ooooooooo ";
"oXXXXXXXX. oXXXXXXX. ";
"oXXXXXXXX. oXXXXXXX. ";
"oXXXXXXXX. oXXXXXXX. ";
"oXXXXXXXX. oXXXXXXX. ";
"o......... o........ ";
"                     ";
"oooooooooo ooooooooo ";
"oXXXXXXXX. oXXXXXXX. ";
"oXXXXXXXX. oXXXXXXX. ";
"oXXXXXXXX. oXXXXXXX. ";
"oXXXXXXXX. oXXXXXXX. ";
"o......... o........ ";
"                     "
|] 

let text = [|
"21 21 5 1" ;
"  c Gray0" ;
". c #7b7b7b" ;
"X c #d6d6d6" ;
"o c Gray87" ;
"O c Gray100" ;
"....................O" ;
".                  XO" ;
". OOOOOOOOOOOOOOOOOXO" ;
". OOOOOOO OOOOOOOOOXO" ;
". OOOOOOO OOOOOOOOOXO" ;
". OO   OO o  OOo  OXO" ;
". O.OOO O  Oo O Oo XO" ;
". OO    O OOO O OOOXO" ;
". O OOO O OOO O OOOXO" ;
". O OOO O OOo O Oo XO" ;
". OO    O    OOo  OXO" ;
". OOOOOOOOOOOOOOOOOXO" ;
". OOOOO OOOOOOOOO  XO" ;
". OOOOO OO   OOO oOXO" ;
". OO    O oOo OO OOXO" ;
". O oOo O oOO O   OXO" ;
". O OOO O    OOO OOXO" ;
". O oOo O OOO.OO OOXO" ;
". OO    OO   OOO OOXO" ;
".XXXXXXXXXXXXXXXXXXXO" ;
"OOOOOOOOOOOOOOOOOOOOO"
|]

let toggle_button = [|
"21 21 6 1" ;
"  c Gray0" ;
". c #7b7b7b" ;
"X c #d6d6d6" ;
"o c #b3cece" ;
"O c Gray100" ;
"+ c None" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+..................O+" ;
"+.                 O+" ;
"+. XXXXXXXXXXXXXXXXO+" ;
"+. XXXXXXXXXXXXXXXXO+" ;
"+. XXX   XXX XXX XXO+" ;
"+. XX XXX XX  XX XXO+" ;
"+. XX XXX XX  XX XXO+" ;
"+. XX XXX XX X X XXO+" ;
"+. XX XXX XX XX  XXO+" ;
"+. XX XXX XX XX  XXO+" ;
"+. XXX   XXX XXX XXO+" ;
"+. XXXXXXXXXXXXXXXXO+" ;
"+. XXXXXXXXXXXXXXXXO+" ;
"+. XXXXXXXXXXXXXXXXO+" ;
"+OOOOOOOOOOOOOOOOOOO+" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++"
|]

let toolbar = [|
"21 21 6 1" ;
"  c Gray0" ;
". c #7b7b7b" ;
"X c #d6d6d6" ;
"o c #b3cece" ;
"O c Gray100" ;
"+ c None" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+OOOOOOOOOOOOOOOOOOO " ;
"+OXXXXXXXXXXXXXXXXX. " ;
"+OXOOOO OOOO OOOO X. " ;
"+OXOXXX OXXX OXXX X. " ;
"+OXOXXX OXXX OXXX X. " ;
"+OXO    O    O    X. " ;
"+OXXXXXXXXXXXXXXXXX. " ;
"+O.................. " ;
"+                    " ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++"
|]

let tree = [|
"21 21 7 1";
"  c Gray0";
". c #7b7b7b";
"X c Green";
"o c Cyan";
"O c Yellow";
"+ c #b3cece";
"@ c None";
"@   @@@@@@@@@@@@@@@@@";
"@ o @......@@@@@@@@@@";
"@   @@@@@@@@@@@@@@@@@";
"@@ @@@@@@@@@@@@@@@@@@";
"@@ @@   @@@@@@@@@@@@@";
"@@    O @......@@@@@@";
"@@ @@   @@@@@@@@@@@@@";
"@@ @@@ @@@@@@@@@@@@@@";
"@@ @@@ @@   @@@@@@@@@";
"@@ @@@    X @......@@";
"@@ @@@ @@   @@@@@@@@@";
"@@ @@@ @@@@@@@@@@@@@@";
"@@ @@@ @@   @@@@@@@@@";
"@@ @@@    X @......@@";
"@@ @@@@@@   @@@@@@@@@";
"@@ @@@@@@@@@@@@@@@@@@";
"@@ @@   @@@@@@@@@@@@@";
"@@    O @......@@@@@@";
"@@@@@   @@@@@@@@@@@@@";
"@@@@@@ @@@@@@@@@@@@@@";
"@@@@@@ @@@@@@@@@@@@@@"
|] 

let tree_minus = [|
"     9     9        2            1" ;
". c #000000" ;
"# c #f8fcf8" ;
"........." ;
".#######." ;
".#######." ;
".#######." ;
".#.....#." ;
".#######." ;
".#######." ;
".#######." ;
"........."
|]

let tree_plus = [|
"     9     9        2            1" ;
". c #000000" ;
"# c #f8fcf8" ;
"........." ;
".#######." ;
".###.###." ;
".###.###." ;
".#.....#." ;
".###.###." ;
".###.###." ;
".#######." ;
"........."
|]

let vbox = [|
"21 21 4 1" ;
"  c Gray0" ;
". c #7b7b7b" ;
"X c #d6d6d6" ;
"o c Gray100" ;
"oooooooooooooooooooo " ;
"oXXXXXXXXXXXXXXXXXX. " ;
"oXXXXXXXXXXXXXXXXXX. " ;
"oXXXXXXXXXXXXXXXXXX. " ;
"oXXXXXXXXXXXXXXXXXX. " ;
"o................... " ;
"                     " ;
"oooooooooooooooooooo " ;
"oXXXXXXXXXXXXXXXXXX. " ;
"oXXXXXXXXXXXXXXXXXX. " ;
"oXXXXXXXXXXXXXXXXXX. " ;
"oXXXXXXXXXXXXXXXXXX. " ;
"o................... " ;
"                     " ;
"oooooooooooooooooooo " ;
"oXXXXXXXXXXXXXXXXXX. " ;
"oXXXXXXXXXXXXXXXXXX. " ;
"oXXXXXXXXXXXXXXXXXX. " ;
"oXXXXXXXXXXXXXXXXXX. " ;
"o................... " ;
"                     "
|]

let vbutton_box = [|
"21 21 6 1" ;
"  c Gray0" ;
". c #7b7b7b" ;
"X c #d6d6d6" ;
"o c #b3cece" ;
"O c Gray100" ;
"+ c None" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++" ;
"++++++++OOOOO +++++++" ;
"++++++++OXXX. +++++++" ;
"++++++++OXXX. +++++++" ;
"++++++++O.... +++++++" ;
"++++++++      +++++++" ;
"+++++++++++++++++++++" ;
"++++++++OOOOO +++++++" ;
"++++++++OXXX. +++++++" ;
"++++++++OXXX. +++++++" ;
"++++++++O.... +++++++" ;
"++++++++      +++++++" ;
"+++++++++++++++++++++" ;
"++++++++OOOOO +++++++" ;
"++++++++OXXX. +++++++" ;
"++++++++OXXX. +++++++" ;
"++++++++O.... +++++++" ;
"++++++++      +++++++" ;
"+++++++++++++++++++++" ;
"+++++++++++++++++++++"
|]

let viewport = [|
"21 21 7 1" ;
"  c Gray0" ;
". c #7b7b7b" ;
"X c #d6d6d6" ;
"o c #b3cece" ;
"O c Gray87" ;
"+ c Gray100" ;
"@ c None" ;
"@@@@@@@@@@@@@@@@@@@@@" ;
"@...................@" ;
"@.                +O@" ;
"@. XXXXXXXXXXXXXXX+O@" ;
"@. XXXXXXXXXXXXXXX+O@" ;
"@. XXXXXXXXXXXXXXX+O@" ;
"@. XXXXXXXXXXXXXXX+O@" ;
"@. XXXXXXXXXXXXXXX+O@" ;
"@. XXXXXXXXXXXXXXX+O@" ;
"@. XXXXXXXXXXXXXXX+O@" ;
"@. XXXXXXXXXXXXXXX+O@" ;
"@. XXXXXXXXXXXXXXX+O@" ;
"@. XXXXXXXXXXXXXXX+O@" ;
"@. XXXXXXXXXXXXXXX+O@" ;
"@. XXXXXXXXXXXXXXX+O@" ;
"@. XXXXXXXXXXXXXXX+O@" ;
"@. XXXXXXXXXXXXXXX+O@" ;
"@. XXXXXXXXXXXXXXX+O@" ;
"@.+++++++++++++++++O@" ;
"@.OOOOOOOOOOOOOOOOOO@" ;
"@@@@@@@@@@@@@@@@@@@@@"
|]

let vpaned = [|
"21 21 4 1";
"  c Gray0";
". c #7b7b7b";
"X c #d6d6d6";
"o c Gray100";
"oooooooooooooooooooo ";
"oXXXXXXXXXXXXXXXXXX. ";
"oXXXXXXXXXXXXXXXXXX. ";
"oXXXXXXXXXXXXXXXXXX. ";
"oXXXXXXXXXXXXXXXXXX. ";
"oXXXXXXXXXXXXXXXXXX. ";
"oXXXXXXXXXXXXXXXXXX. ";
"oXXXXXXXXXXX.....XX. ";
"oXXXXXXXXXXX.ooo..X. ";
"o............ooo.... ";
"            .ooo..   ";
"oooooooooooo......oo ";
"oXXXXXXXXXXXX.....X. ";
"oXXXXXXXXXXXXXXXXXX. ";
"oXXXXXXXXXXXXXXXXXX. ";
"oXXXXXXXXXXXXXXXXXX. ";
"oXXXXXXXXXXXXXXXXXX. ";
"oXXXXXXXXXXXXXXXXXX. ";
"oXXXXXXXXXXXXXXXXXX. ";
"o................... ";
"                     "
|] 

let vruler = [|
"21 21 3 1";
"  c Gray0";
". c #b3cece";
"X c None";
"XXXX   XXXXXXXXXXXXXX";
"XXXX X XX        XXXX";
"XXXX X XXXXXXXXX XXXX";
"XXXX   XXXXXXXXX XXXX";
"XXXXXXXXXXXXX    XXXX";
"XXXXXXXXXXXXXXXX XXXX";
"XXXXXXXXXXXXXXXX XXXX";
"XXXXXXXXXXX      XXXX";
"XXXXXXXXXXXXXXXX XXXX";
"XXXXXXXXXXXXXXXX XXXX";
"XXXXXXXXXXXXX    XXXX";
"XXXXXXXXXXXXXXXX XXXX";
"XXXXXXXXXXXXXXXX XXXX";
"XXXXXXXXXXX      XXXX";
"XXXXXXXXXXXXXXXX XXXX";
"XXXXXXXXXXXXXXXX XXXX";
"XXXX   XXXXXX    XXXX";
"XXXX XXXXXXXXXXX XXXX";
"XXXX   XXXXXXXXX XXXX";
"XXXXXX XX        XXXX";
"XXXX   XXXXXXXXXXXXXX"
|] 

let vseparator = [|
"21 21 4 1" ;
"  c #7b7b7b" ;
". c #b3cece" ;
"X c Gray100" ;
"o c None" ;
"ooooooooooooooooooooo" ;
"oooooooooo Xooooooooo" ;
"oooooooooo Xooooooooo" ;
"oooooooooo Xooooooooo" ;
"oooooooooo Xooooooooo" ;
"oooooooooo Xooooooooo" ;
"oooooooooo Xooooooooo" ;
"oooooooooo Xooooooooo" ;
"oooooooooo Xooooooooo" ;
"oooooooooo Xooooooooo" ;
"oooooooooo Xooooooooo" ;
"oooooooooo Xooooooooo" ;
"oooooooooo Xooooooooo" ;
"oooooooooo Xooooooooo" ;
"oooooooooo Xooooooooo" ;
"oooooooooo Xooooooooo" ;
"oooooooooo Xooooooooo" ;
"oooooooooo Xooooooooo" ;
"oooooooooo Xooooooooo" ;
"oooooooooo Xooooooooo" ;
"ooooooooooooooooooooo"
|]

let window = [|
"21 21 11 1" ;
"  c Gray0" ;
". c #00007b" ;
"X c #7b7b7b" ;
"o c Green" ;
"O c Cyan" ;
"+ c Red" ;
"@ c Yellow" ;
"# c #d6d6d6" ;
"$ c #b3cece" ;
"% c Gray100" ;
"& c None" ;
"&&&&&&&&&&&&&&&&&&&&&" ;
"&&&&&&&&&&&&&&&&&&&&&" ;
"&&&&&&&&&&&&&&&&&&&&&" ;
"XXXXXXXXXXXXXXXXXXXX&" ;
"X.+@...............X " ;
"X.Oo.%%%.%%.....# #X " ;
"XXXXXXXXXXXXXXXXXXXX " ;
"X#%%%%%%%%%%%%%%%%%X " ;
"X#%%%%%%%%%%%%%%%%%X " ;
"X#%%%%%%%%%%%%%%%%%X " ;
"X#%%%%%%%%%%%%%%%%%X " ;
"X#%%%%%%%%%%%%%%%%%X " ;
"X#%%%%%%%%%%%%%%%%%X " ;
"X#%%%%%%%%%%%%%%%%%X " ;
"X#%%%%%%%%%%%%%%%%%X " ;
"X#%%%%%%%%%%%%%%%%%X " ;
"X#%%%%%%%%%%%%%%%%%X " ;
"XXXXXXXXXXXXXXXXXXXX " ;
"&                    " ;
"&&&&&&&&&&&&&&&&&&&&&" ;
"&&&&&&&&&&&&&&&&&&&&&"
|]


let question_mark = [|
"21 21 4 1";
"       c None";
".      c #7B7B7B";
"+      c #000000";
"@      c #FFFFFF";
"                     ";
"                     ";
"                     ";
"      @@@@@          ";
"     @     @@        ";
"    @        @       ";
"   @          @      ";
"   @          @      ";
"    @         @      ";
"             @       ";
"            @        ";
"          @@         ";
"         @           ";
"        @            ";
"        @            ";
"        @            ";
"        @            ";
"                     ";
"        @            ";
"                     ";
"                     "
|] 

let create_pixmap i =
  let gdk_pix = GDraw.pixmap_from_xpm_d ~data: i 
      ~colormap: (Gdk.Color.get_system_colormap ())
      () 
  in
  let pix = GMisc.pixmap gdk_pix () in
  pix

let class_icons =
    [ Custom_box, Some custom ;
      Button, Some button ;
      Toggle_button, Some toggle_button ;
      Check_button, Some check_button ;
      Radio_button, Some radio_button ;
      Toolbar, Some toolbar ;
      Hbox, Some hbox ;
      Vbox, Some vbox ;
      Hbutton_box, Some hbutton_box ;
      Vbutton_box, Some vbutton_box ;
      Fixed, Some fixed ;
      Frame, Some frame ;
      Aspect_frame, Some aspect_frame ;
      Scrolled_window, Some scrolled_window ;
      Event_box, Some event_box ;
      Handle_box, Some handle_box ;
      Viewport, Some viewport ;
      Hseparator, Some hseparator ;
      Vseparator, Some vseparator ;
      Clist, Some clist ;
      Label, Some label ;
      Statusbar, Some statusbar ;
      Notebook, Some notebook ;
      Color_selection, Some color_selection ;
      Pixmap, Some pixmap ;
      Pixmap_file, Some pixmap ;
      Pixmap_data, Some pixmap ;
      Pixmap_code, Some pixmap ;
      Entry, Some entry ;
      Spin_button, Some spin_button ;
      Combo, Some combo ;
      Tree, Some tree ;
      Text, Some text ;
      Hpaned, Some hpaned ;
      Vpaned, Some vpaned ;
      Window, Some window ;
      Menubar, Some menubar ;
      Menu_item, Some menu_item ;
      Tearoff_menu_item, None ;
      Check_menu_item, Some check_menu_item ;
      Radio_menu_item, Some radio_menu_item ;
      Menu_separator, None ;
      Menu, Some menu ;
      Table, Some table ;
      Progress_bar, Some progress_bar ;
      HRuler, Some hruler ;
      VRuler, Some vruler ;
      Arrow, Some arrow ;
      Calendar, Some calendar ;
      Drawing_area, Some drawing_area ;
      Font_selection, Some font_selection ;
    ] 

(** Get an icon to represent a kind of gui element. *)
let icon_of_gui_element_class cl =
  try
    List.assoc cl class_icons
  with
    Not_found ->
      raise (Failure "a constructor has no icon in Zog_gui_icons.icon_of_gui_element_class")
