(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

let software = "Zoggy"
let software_version = "1.2"


(** {2 Command line options and messages} *)

let usage = Sys.argv.(0)^" [options] <file>\n"
let options_are = "Options are :"

(** {2 Messages and labels} *)

let yes = "Yes"
let no = "No"
let save_before_exit = "Save before exit ?"
let question = "Question"
let error = "Error"
let fun_unit = "fun () -> "
let generated_by = "File generated by "^software^" version "^software_version
let parameters = "Parameters"
let name = "Name : "
let entity = "Entity"
let add_parameter = "Add parameter"
let cant_add_element name = "You can't add this element to "^name^"."
let properties = "Properties"
let generated_by = "File generated by "^software^" version "^software_version
let only_one_root = "An entity can have only one root element."
let preview = "Preview"
let class_not_found name = "No class found with name "^name^"."
let property_not_found name = "No property found with name "^name^"."
let ocamlid = "OCaml id"
let enter_label = "Enter label"
let item_label = "Item label (of type string) : "
let menu_item = "Menu item"
let in_interface = "In interface"
let not_in_interface = "Not in inteface"
let empty = "Empty"
let with_label = "With label"
let enter_text = "Enter text"
let pixmap_file = "file"
let pixmap_data = "data"
let pixmap_code = "code"

(** {2 Menu labels} *)

let mnFile = "File"
let mnSave = "Save"
let mnEdit = "Edit"
let mnNode = "Elements"
let mnHelp = "?"
let mnQuit = "Quit"
let mnCopy = "Copy"
let mnPaste = "Paste"
let mnCut = "Cut"
let mnRemove = "Remove"
let mnEdit_selected = "Edit selected"
let mnEntity_properties = "Entity properties"
let mnEdit_params = "Edit parameters"
let mnEntity = entity
let mnAdd_entity = "Add entity"
let mnOpen_entity = "Open entity"
let mnRemove_entity = "Remove entity"
let mnInsert_a_m = "Insert (a..m)"
let mnInsert_n_z = "Insert (n..z)"
let mnUp = "Element up"
let mnUp_entity = "Entity up"
let mnTemplates = "Templates"
