(*********************************************************************************)
(*                Cameleon                                                       *)
(*                                                                               *)
(*    Copyright (C) 2005,2006 Institut National de Recherche en Informatique     *)
(*    et en Automatique. All rights reserved.                                    *)
(*                                                                               *)
(*    This program is free software; you can redistribute it and/or modify       *)
(*    it under the terms of the GNU Library General Public License as            *)
(*    published by the Free Software Foundation; either version 2 of the         *)
(*    License, or  any later version.                                            *)
(*                                                                               *)
(*    This program is distributed in the hope that it will be useful,            *)
(*    but WITHOUT ANY WARRANTY; without even the implied warranty of             *)
(*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *)
(*    GNU Library General Public License for more details.                       *)
(*                                                                               *)
(*    You should have received a copy of the GNU Library General Public          *)
(*    License along with this program; if not, write to the Free Software        *)
(*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA                   *)
(*    02111-1307  USA                                                            *)
(*                                                                               *)
(*    Contact: Maxence.Guesdon@inria.fr                                          *)
(*                                                                               *)
(*********************************************************************************)

(** The "ocamloutput" view, to display output of evaluation of ocaml code. *)

class outputview :
  ?attributes:(string * string) list ->
    Ed_view.topwin ->
    ('a -> unit) ->
    object ('a)
      inherit Ed_view.dyn_label
      inherit Ed_view.dyn_destroyable
      method attributes : (string * string) list
      method box : GObj.widget
      method close : unit
      method copy : (unit -> unit) option
      method cut : (unit -> unit) option
      method dup : Ed_view.topwin -> Ed_view.gui_view option
      method filename : string
      method grab_focus : unit
      method key_bindings : (Okey.keyhit_state * string) list
      method kind : string
      method menus : (string * GToolbox.menu_entry list) list
      method minibuffer : Ed_minibuffer.minibuffer
      method paste : (unit -> unit) option
      
      (** To print in the buffer; used to print the result of evaluation
           of ocaml code. *)
      method print : string -> unit
      
      method reload : (unit -> unit) option
      method save : (unit -> unit) option
      method save_as : (unit -> unit) option
      method set_on_focus_in : (unit -> unit) -> unit
      method source_buffer : GSourceView.source_buffer
      method source_view : GSourceView.source_view
    end

(** The current view, if any, to have only one view
   to display output of evaluation.*)
val view : outputview option ref

val open_view :
  Ed_view.topwin ->
    Ed_view.gui_view ->
    ?attributes:(string * string) list ->
    string -> [> `New_view of Ed_view.gui_view | `Use_view of Ed_view.gui_view ]

(** The original function of the "print_ocaml_output" command. *)
val print_ocaml_output : string array -> unit

class factory : Ed_view.view_factory
