#ifndef VIDEOOPTIONS_HPP
#define VIDEOOPTIONS_HPP

#include <qdom.h>

/* 
  Note: 'S' stands for 'Structure': this really isn't a class, merely
  a struct-with-functions.
*/

struct SVideoOptions
{
private:
   QDomElement Me;

   QDomText *pValues;
   QDict<QDomText> Opts;

   void Populate(QDomDocument &doc);

public:
   SVideoOptions(QDomDocument &doc);
   SVideoOptions(const SVideoOptions &);
   ~SVideoOptions();

   void SetXML(const QDomElement &el);
   QDomNode GetXML();
   
   // attributes
   QString GetDeviceName() const;
   void SetDeviceName(const QString &name);
   QString GetNodeName() const;
   void SetNodeName(const QString &node);

   // values
   QString GetBaseName() const;
   void SetBaseName(const QString &basename);

   QColor GetTextColor() const;
   void SetTextColor(const QColor &color);
   void SetTextColor(const QString &color_name);

   QFont GetTextFont() const;
   void SetTextFont(const QFont &font);
   void SetTextFont(const QString &font_name);

   bool GetTimeInImage() const;
   void SetTimeInImage(bool);

   QString GetFileFormat() const;
   void SetFileFormat(const QString &format);

   int GetSaveOption() const;
   void SetSaveOption(int);

   int GetSequence() const;
   void SetSequence(int);   

   int GetMaxSequence() const;
   void SetMaxSequence(int);
   
   bool GetSaveToDisk() const;
   void SetSaveToDisk(bool);
   
   bool GetFTPToServer() const;
   void SetFTPToServer(bool);

   QString GetFTPServer() const;
   void SetFTPServer(const QString &server);

   QString GetFTPPath() const;
   void SetFTPPath(const QString &path);

   QString GetFTPUser() const;
   void SetFTPUser(const QString &user);

   QString GetFTPPass() const;
   void SetFTPPass(const QString &pass);
};

#endif
