#ifndef FTPCLIENT_HPP
#define FTPCLIENT_HPP

#if HAVE_CONFIG_H
#include "config.h"
#endif

#include <netdb.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/types.h>

#include <qsocketnotifier.h>

class CFTPClient: public QObject
{
   Q_OBJECT
private:
   QString UserName, Password;
   struct sockaddr_in MyAddr, ServerAddress;

   int CtrlFD, ListenFD, DataFD, LocalFileFD;
   char *inputbuffer, *linebuffer, *responsebuffer;
   char LastChar;
   bool MultiLine;
   int LineLen, RespLen; // Characters in linebuffer resp. response buffer
   int Response;    // FTP response code
   bool Direction;	// false = in, true = out
   QString RemoteFileName;

   char *outputbuffer;

   uchar *transferbuffer;
   int TBufLen, TBufTail, TBufHead, TBufUsed; // rotating buffer
   int TotalTransfered;

   QSocketNotifier *pControlPipe, *pListenPipe, *pDataPipe;
   
   int CurrentState, NextState;

   void InitBuffers();
   void CloseAllFD();
   int SetupControl();
   void CloseControl();
   int SetupListen();
   void CloseListen();
   int SetupFile(const char *filename);
   void CloseFile();
   void CloseData();

   void SetState(int new_op);

   void InterpretLine();
   void InterpretResponse();

   void Send();
   void SendUser();
   void SendPass();
   void SendPort(struct sockaddr_in &addr, int port);
   void SendStore(const char *filename);

   void StartSending();
   void StartReceiving();

private slots:
   void ControlRead(int fd);
   void ListenRead(int fd);
   void DataRead(int fd);
   void DataWrite(int fd);

public:
   enum {
     Nop,		///< Not connected
     Connecting,	///< Busy connecting to server
     Connected,		///< Server reached
     Login,		///< Connected, sending username
     Authenticate,	///< Connected, sending password
     Failed,		///< Connected, but failed to authenticate
     LoggedIn,		///< Connected, and logged in
     Ready,		///< Connected, not doing anything
     SettingType,	///< Sent TYPE command
     SendingPort,	///< Sending PORT command to remote end
     Storing,		///< Sent STOR command
     Retrieving,	///< Sent RETR command
     WaitData,		///< Waiting for data connection
     Transfer,		///< Transfering file
     ClosingData,	///< Waiting for 226
     Completed,		///< Transfer completed
     Closing,		///< Closing down (--> Nop)
   } States;

   static const char * StateStr[];   

   CFTPClient();
   ~CFTPClient();

   int GetState();

   int Open(const char *user, const char *pass, const char *server, int port = 21);
   int Upload(const char *local_file, const char *remote_file = NULL);

   void SetTypeAscii();
   void SetTypeBinary();

signals:
   void StateChange(int new_state, int result);

};

#endif
