/*  audiodevs: Abstraction layer for audio hardware & samples
    Copyright (C) 2003-2004 Nemosoft Unv.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For questions, remarks, patches, etc. for this program, the author can be
    reached at camstream@smcc.demon.nl.
*/

/**
  \brief Audio doodads-ands-whistles display class
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/types.h>
#include <unistd.h>

#include <qapplication.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qradiobutton.h>

#include "AudioDisplay.h"
//#include "AudioDisplayFFT.h"
//#include "AudioDisplayVolume.h"

CAudioDisplay::CAudioDisplay(CAudioDevice *audio_device, QWidget *parent, const char *name)
	: QWidget(parent, name, WDestructiveClose)
{
qDebug("CAudioDisplay::CAudioDisplay(\"%s\")", audio_device->GetName().ascii());
   m_pAudio = audio_device;

   m_LeftWidth = 260;
   m_pVolume = 0;
//   pFFT = NULL;

   m_pLeftSide = new CAuControls(this, "Audio Controls");
   m_pLeftSide->move(0, 0);
   m_pLeftSide->setFixedWidth(m_LeftWidth);
   m_pLeftSide->show();

   connect(m_pLeftSide->MixerButton, SIGNAL(clicked()), m_pAudio, SLOT(ShowMixerControls()));
   connect(m_pLeftSide->MixerResetButton, SIGNAL(clicked()), SLOT(ResetMixerSettings()));
   connect(m_pLeftSide->VolumeBarsCheckBox, SIGNAL(toggled(bool)), SLOT(ToggleVolumeBars(bool)));
//   connect(pLeftSide->ShowFFT,  SIGNAL(toggled(bool)), SLOT(ToggleFFT(bool)));
/*
   pRing = new CRingBuffer(200000);

   pAudio = new CAudioThread(audio_device, new CRingBufferWriter(pRing));
   if (pAudio->IsOpen()) {
     pAudio->start();
   }
   else

qDebug("AudioDisplay pid = %d", getpid());
*/

   Audio2Dlg();

   m_MySize.setWidth(m_LeftWidth + 256);
   m_MySize.setHeight(32 + 480);

   if (m_pAudio != 0)
   {
     QDomDocument doc("mxstudio");

     m_pAudio->SetSoundAttributes(SoundAttributes::GetFormat(SoundAttributes::CD));
     if (!m_pAudio->Open(CAudioDevice::Capture))
       qWarning("Failed to open audio device!");
   //ToggleVolumeBars(true);
//   m_pLeftSide->VolumeBarsCheckBox->setChecked(TRUE);
     m_OrgMixerSettings = doc.createElement("mixer_settings");
     doc.appendChild(m_OrgMixerSettings);
     m_pAudio->GetMixerSettings(m_OrgMixerSettings);
     qDebug("Current mixer config: " + doc.toString());
  }
}


CAudioDisplay::~CAudioDisplay()
{
qDebug("CAudioDisplay::~CAudioDisplay()");
   if (m_pVolume) {
     m_pVolume->Quit();
     delete m_pVolume;
     m_pVolume = 0;
   }
/*
   if (pFFT) {
     pFFT->Quit();
     pFFT->wait();
     delete pFFT;
   }
*/
   if (m_pAudio) {
     m_pAudio->Close();
     m_pAudio = 0;
   }
//   pFFT = NULL;
}


// private

/**
  \brief  Read settings from audio device, change dialog properties
*/


void CAudioDisplay::Audio2Dlg()
{
/*
   SoundAttributes attr;
   int speeds[] = { 8000, 11025, 22050, 44100, 48000 };
   int speed_sel = -1, speed_diff, i, j;

   if (pAudio == NULL || pLeftSide == NULL)
     return;
   attr = pAudio->GetAttributes();
   qDebug("Audio2Dlg: speed = %d, bits = %d, sign = %c, channels = %d",
           attr.SampleRate, attr.Bits, attr.Sign ? 'S' : 'U', attr.Channels);

   // Find closest speed
   speed_diff = 9999999;
   for (i = 0; i < 5; i++) {
      j = speeds[i] - attr.SampleRate;
      if (j < 0)
        j = -j;
      if (j < speed_diff) {
        speed_diff = j;
        speed_sel = i;
      }
   }
   pLeftSide->Speed->setCurrentItem(speed_sel);
   // mono/stereo
   if (attr.Channels == 1)
     pLeftSide->Mono->setChecked(TRUE);
   if (attr.Channels == 2)
     pLeftSide->Stereo->setChecked(TRUE);
   // format
   if (attr.Bits == 8 && !attr.Sign)
     pLeftSide->Unsigned8->setChecked(TRUE);
   if (attr.Bits == 16 && attr.Sign)
     pLeftSide->Signed16->setChecked(TRUE);
*/
}


void CAudioDisplay::ArrangeRight()
{
   qApp->lock();
   if (m_pVolume)
   {
     m_pVolume->move(m_LeftWidth, 0);
     m_pVolume->SetLength(256);
   }
//   if (pFFT)    pFFT->move(LeftWidth, 32);
   qApp->unlock();
}

// private slots

void CAudioDisplay::ToggleVolumeBars(bool on)
{
qDebug("CAudioDisplay::ToggleVolumeBars(%s)", on ? "TRUE" : "FALSE");
   if (on && !m_pVolume) {
     CAudioRingBufferReader *pReader;
     pReader = m_pAudio->CreateReader();
     if (pReader != 0)
     {
       m_pVolume = new CAudioDisplayVolume(pReader, CAudioDisplayVolume::Stack, this, "volume bars");
     }
     if (m_pVolume != 0)
     {
       m_pVolume->show();
       m_pVolume->start(); // thread
     }
     else
     {
       // No point in having this around, then
       delete pReader;
     }
   }
   if (!on && m_pVolume) {
     m_pVolume->Quit();
     delete m_pVolume; // destroys reader as well
     m_pVolume = 0;
   }
/*
   qApp->lock();
   pLeftSide->PeakHold->setEnabled(on);
   qApp->unlock();
*/
   ArrangeRight();
}

void CAudioDisplay::ToggleFFT(bool on)
{
qDebug("CAudioDisplay::ToggleFFT(%s)", on ? "TRUE" : "FALSE");
/*
   if (on && !pFFT) {
     qApp->lock();
     pFFT = new CAudioDisplayFFT(pAudio, new CRingBufferReader(pRing), this, "fft display");
     pFFT->show();
     qApp->unlock();
     pFFT->start(); // thread
   }
   if (!on && pFFT) {
     pFFT->Quit();
     pFFT->wait();
     delete pFFT;
     pFFT = NULL;
   }
   qApp->lock();
   pLeftSide->FFTRadix->setEnabled(on);
   pLeftSide->FFTSensitivity->setEnabled(on);
   qApp->unlock();
   ArrangeRight();
*/
}

void CAudioDisplay::ResetMixerSettings()
{
   qDebug(">> CAudioDisplay::ResetMixerSettings()");
   if (m_pAudio != 0)
   {
     m_pAudio->SetMixerSettings(m_OrgMixerSettings);
   }
   qDebug("<< CAudioDisplay::ResetMixerSettings()");
}



// public

QSize CAudioDisplay::sizeHint() const
{
   return m_MySize;
}
