#include "main.h"

void ReallyAddHouse(int x, int y)
{
    House[x][y]=1;
    Blit(x*BSIZE,y*BSIZE,HousePic);
    BlitToBB(x*BSIZE,y*BSIZE,HousePic);
}

void AddHouses(int number)
{
    int i,x,y,l;
    char data[4];

    printf("Placing new houses.\n"); 
    for (i=0;i<number;i++) {
	if (Master) {
	    do {
		x=abrand(0,Width-1);
    	        y=abrand(0,Height-1);
		l=Landscape[x][y];
	        if (l==127) l=0;
	    } while ((!FieldFree(x,y))||(BPlayer[l].Secured[x][y]));
	    ReallyAddHouse( x, y);
	    data[0]=3;
	    data[1]=NET_ADDHOUSE;
	    data[2]=x;
	    data[3]=y;
	    Net_Send(data);
	}
    }    
    printf("New houses placed.\n"); 
}

void House2Tank(int x, int y)
{
    SDL_Rect rect;
    char send[7];

    if (Master) {
	House[x][y]=0;
	if (TankNum<MAX_TANKNUM-1) {
	    // erase house
	    rect.x=x*BSIZE;
	    rect.y=y*BSIZE;
	    rect.w=rect.h=BSIZE;
	    SDL_BlitSurface( BackPic, &rect, Screen, &rect);
	
    	    // create Tank
	    Tank[TankNum].x=x;
	    Tank[TankNum].y=y;
	    Tank[TankNum].dir=abrand(0,3);
	    Tank[TankNum].WaitTime=abrand(0,3000);
	    
	    send[0]=6;
	    send[1]=NET_NEWTANK;
	    send[2]=(char)x;
	    send[3]=(char)y;
	    send[4]=(char)Tank[TankNum].dir;
	    send[5]=(char)(Tank[TankNum].WaitTime/256);
	    send[6]=(char)(Tank[TankNum].WaitTime%256);
	    Net_Send(send);

	    TankNum++;
	
	    // Draw Tank
	    Blit(x*BSIZE, y*BSIZE, TankPic[Tank[TankNum-1].dir]);
	    SDL_BlitSurface( Screen, &rect, BackBuffer, &rect);
	}
	else printf("Too many Tanks!\n");
    }
}

void DrawTank( int i )
{
    if (i>=TankNum) {
	printf ("Cannot DrawTank. TankNum too big (%d>=%d).",i,TankNum);
	return;
    }

    Blit(Tank[i].x*BSIZE, Tank[i].y*BSIZE, TankPic[Tank[i].dir]);
    SDL_BlitSurface( Screen, &blitrect, BackBuffer, &blitrect);
}

void UndrawTank( int i )
{
    SDL_Rect rect;

    if (i>=TankNum) {
	printf ("Cannot UndrawTank. TankNum too big (%d>=%d).",i,TankNum);
	return;
    }

    rect.x=Tank[i].x*BSIZE;
    rect.y=Tank[i].y*BSIZE;
    rect.w=rect.h=BSIZE;
    SDL_BlitSurface( BackPic, &rect, Screen, &rect);
    SDL_BlitSurface( BackPic, &rect, BackBuffer, &rect);
    AddThisRect(rect);
}

void HandleTanks()
{
    int i,xdir,ydir,turn=0,a,x,y;
    char send[6];
    
    if (Master) {
        for (i=0;i<TankNum;i++) {
    	    Tank[i].WaitTime-=Speed;
	    if (Tank[i].WaitTime<0) {
		UndrawTank(i);
		switch(Tank[i].dir) {
	    	    case 0:
			xdir=0;
			ydir=-1;
		    break;
		    case 1:
			xdir=1;
	    		ydir=0;
	    	    break;
		    case 2:
	    		xdir=0;
			ydir=1;
		    break;
	    	    case 3:
			xdir=-1;
			ydir=0;
		    break;
		    default:
			puts("ERROR in HandleTanks();");
			xdir=-1;
			ydir=0;
		    break;
		}
		if (WallCheck(Tank[i].x+xdir,Tank[i].y+ydir)) {
		    Destroy((Tank[i].x+xdir)*BSIZE,(Tank[i].y+ydir)*BSIZE,0);
		    Tank[i].WaitTime+=10000;
		    send[0]=3;
		    send[1]=NET_TANKSHOOT;
		    send[2]=Tank[i].x+xdir;
		    send[3]=Tank[i].y+ydir;
		    Net_Send(send);
		}
		else if ((FieldFree(Tank[i].x+xdir,Tank[i].y+ydir))&&(!House[Tank[i].x+xdir][Tank[i].y+ydir])) {
		    x=Tank[i].x;
		    y=Tank[i].y;
		    turn=!abrand(0,1);
		    for (a=0;a<15;a++) {
			x+=xdir;
			y+=ydir;
			if (WallCheck(x,y))
			    turn=0;
		    }
		} else 
		    turn=1;
		if (turn) {
		    Tank[i].dir+=abrand(-1,1);
		    if (Tank[i].dir>3) Tank[i].dir=0;
		    if (Tank[i].dir<0) Tank[i].dir=3;
		    Tank[i].WaitTime+=500;
		} else {
		    Tank[i].x+=xdir;
		    Tank[i].y+=ydir;
		    Tank[i].WaitTime+=1000;
		}
		if (abrand(0,50)==0) {
		    x=Tank[i].x+abrand(-2,2);
		    y=Tank[i].y+abrand(-2,2);
		    if (FieldFree(x,y))
			House2Tank(x,y);
		}
		DrawTank(i);
		send[0]=5;
		send[1]=NET_TANKMOVE;
		send[2]=i;
		send[3]=Tank[i].x;
		send[4]=Tank[i].y;
		send[5]=Tank[i].dir;
		Net_Send(send);
	    }
	}
    }
}
