#
# $Header: /cvsroot/catalog/catalog/t/04dmoz.t,v 1.4 2001/07/11 10:28:08 loic Exp $
#
use strict;

package main;

use Test;

use Catalog::tools::tools;
use Catalog::dmoz;

require "t/lib.pl";
require "t/fulltext.pl";

if($] < 5.006) {
    print STDERR "require perl-5.6";
    plan test => 0;
    exit 0;
}

#$::opt_verbose = 'dmoz|normal';
$::opt_error_stack = 1;

conftest_generic();

plan test => 1;

{
    my($dmoz) = dmoz_loader();
    my($count) = $dmoz->db()->exec_select_one("select count(*) as count from catalog_category_dmoz")->{'count'};
    ok($count, 12, "unexpected number of categories $count");
}

conftest_generic_clean();

# Local Variables: ***
# mode: perl ***
# End: ***
