/*
   Copyright (C) 1999 J.H.M. Dassen (Ray) <jdassen@wi.LeidenUniv.nl>
   Copyright (C) 1999 Antti-Juhani Kaijanaho <gaia@iki.fi>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef UTIL_H
#define UTIL_H

#ifndef max
#define max(a, b) (((a) > (b)) ? (a) : (b))
#endif

#ifndef min
#define min(a, b) (((a) < (b)) ? (a) : (b))
#endif

#define lengthof(array) (sizeof(array) / sizeof(array[0]))
/* the number of elements in an array (a real one, NOT a pointer) */

extern int msglevel;
extern int suppress_warnings;
extern int num_warnings;

#ifdef __GNUC__
#  define FORMAT(x) __attribute__((format x))
#else 
#  define FORMAT(x) /* nothing */
#endif

void warning(char *format, ...) FORMAT((printf, 1, 2));
/* print an unsurpressable warning */

void panic(char *format, ...) FORMAT((printf, 1, 2));
/* print a message, and exit */

#if defined(NDEBUG) && defined(__GNUC__)
/* gcc's cpp has extensions; it allows for macros with a variable number of
 *    arguments. We use this extension here to preprocess eassert away. */
#define eassert(int expr, format, args...) ((void)0)
#else
void eassert(int expr, char *format, ...) FORMAT((printf, 2, 3));
/* Like assert(), but with a descriptive message */
#endif

#if defined(NDEBUG) && defined(__GNUC__)
/* gcc's cpp has extensions; it allows for macros with a variable number of
   arguments. We use this extension here to preprocess pmesg away. */
#define pmesg(level, format, args...) ((void)0)
#else
void pmesg(int level, char *format, ...) FORMAT((printf, 2, 3));
/* print a message, if it is considered significant enough.
      Adapted from [K&R2], p. 174 */
#endif

#define enomem( ) panic("Out of memory (near %s line %d)\n", __FILE__, __LINE__)

#define NOTREACHED panic("Please report a bug.  Include in the report " \
                         "the following information,\n" \
                         "exactly as it is written here: " \
                         "\"%s:%i was reached\".\n" \
                         "Please include in your report as much detail " \
                         "as possible about what you\n" \
                         "were doing at the " \
                         "time you saw this message.  Thank you.\n", \
                         __FILE__, __LINE__)


/* Conver a string in-place to upper case */
void strupcase(char * s);

/* Return a malloc'ed upper-case copy of a string, NULL if out of memory. */
char * strupcasedup(char const * s);

/* Simple shell-style pattern matching. Wildcards are:
 * '*': matches any string (including empty string)
 * '?': matches any single character
 * '#': matches any decimal digit (convenient for TeX font names)
 * Returns true if matching, 0 otherwise.
 */
int patmatch(char const * pat, char const * s);


#endif /* UTIL_H */
