/**
 * @file amigapar.h
 * Interface to accessing the Amiga parallel port
 * @author Marko Mkel (msmakela@nic.funet.fi)
 * @author Olaf Seibert (rhialto@mbfys.kun.nl)
 */

/*
 * Copyright  1994-1997 Marko Mkel and Olaf Seibert
 * Copyright  2001 Marko Mkel
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef COMM_AMIGA
# include <hardware/cia.h>

extern volatile struct CIA ciaa;
extern volatile struct CIA ciab;

/** the data register of the data lines */
#define DATA		ciaa.ciaprb
/** the data direction register of the data lines */
#define DATA_DDR	ciaa.ciaddrb
/** the data register of the control lines */
#define CTL		ciab.ciapra
/** the data direction register of the control lines */
#define CTL_DDR 	ciab.ciaddra

/** BUSY line */
#define BUSY	(1 << CIAB_PRTRBUSY)	/* == 0x01 */
/** PAPER OUT line */
#define POUT	(1 << CIAB_PRTRPOUT)	/* == 0x02 */

/** Reserve the data lines of the parallel port
 * @param ctl	flag: reserve the control lines as well
 * @return	0 on success, nonzero on failure
 */
int
alloc_port (int ctl);

/** Give back the parallel port
 * @return	0 on success, nonzero on failure
 */
int
free_port (void);

/** Check whether the transfer has been interrupted */
void
check_break (void);

#endif /* COMM_AMIGA */
