/**
 * @file info.h
 * Information structures
 * @author Marko Mkel (msmakela@nic.funet.fi)
 */

/* Copyright  2001 Marko Mkel.

   This file is part of CBMLINK, a program for data communications between
   Commodore 8-bit microcomputers and other computer systems.

   CBMLINK is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   CBMLINK is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   59 Temple Place, Suite 330, Boston, MA 02111 USA. */

/** Command */
enum opcode
{
  REQ_INFO = 0, /**< request for system information */
  REQ_LOAD = 1, /**< load a program */
  REQ_SAVE = 2, /**< save a program */
  REQ_JUMP = 3, /**< jump to the specified address */
  REQ_RUN = 4	/**< start a BASIC program */
};

/** Computer type */
enum cbm
{
  PET = 201,	/**< Commodore PET or CBM 2000 series, BASIC 1.0 */
  PET3 = 202,	/**< Commodore PET or CBM 3000 series, BASIC 2.0 */
  PET4 = 203,	/**< Commodore PET or CBM 4000 or 8000 series, BASIC 4.0 */
  P500 = 205,	/**< Commodore PET II or CBM B series (500) */
  B128 = 210,	/**< Commodore PET II or CBM B series (610 or 710) */
  B256 = 220,	/**< Commodore PET II or CBM B series (620 or 720) */
  Vic = 20,	/**< Commodore VIC-20, VC-20 or VIC-1001 */
  C64 = 64,	/**< Commodore 64 or compatible */
  C128 = 128,	/**< Commodore 128 or 128D */
  C264 = 16	/**< Commodore 264 series (16, 116, plus/4, 232, 264, V364) */
};

/** Machine information structure */
struct hostinfo
{
  /** The computer type */
  enum cbm host;
  /** Driver start address */
  unsigned driver;
  /** BASIC program start address */
  unsigned basic;
};

/** Detect a Commodore computer
 * @param host	host type
 * @return	name of the host
 */
const char*
cbmname (enum cbm host);

#if defined __WIN32 || defined __WIN32__
/** Report a Windows error
 * @param op	the failed operation
 * @param dev	(optional) the device name
 */
void
report_error (const char* op,
	      const char* dev);
#endif /* defined __WIN32 || defined __WIN32__ */
