/**
 * @file serial.h
 * Serial transfer routines
 * @author Marko Mkel (msmakela@nic.funet.fi)
 */

/*
 * Copyright  2001,2002 Marko Mkel.
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef COMM_SERIAL
/** Open the communication channel to direct serial connection
 * @param dev		name of the communication device
 * @param hostinfo	(output) the computer model information
 * @return		zero on success, nonzero on failure
 */
int
serial_init (const char* dev, struct hostinfo* hostinfo);

/** Close the communication channel to direct serial connection */
void
serial_close (void);

/** Send data
 * @param buf		the data to be sent
 * @param len		length of the data in bytes
 * @return		zero on success, nonzero on failure
 */
int
serial_write (const void* buf, unsigned len);

/** Receive data
 * @param buf		the data to be received
 * @param len		length of the data in bytes
 * @return		zero on success, nonzero on failure
 */
int
serial_read (void* buf, unsigned len);
#endif /* COMM_SERIAL */
