#!/bin/sh

set -eu

cat << EOF
/**
 * @file $1-o.h
 * Automatically generated by "$0 $1", do not edit!
 * @author Marko Mkel (msmakela@nic.funet.fi)
 */

/*
 * Copyright  1994-1996 Marko Mkel and Olaf Seibert
 * Copyright  2001-2003 Marko Mkel
 * Original Linux and Commodore 64/128/Vic-20 version by Marko Mkel
 * Ported to the PET and the Amiga series by Olaf Seibert
 * Restructured by Marko Mkel
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

EOF

for i in pet3000 pet4000 cbm cbm2
do
	echo "/** code for the $i series */"
	echo "static const unsigned char $1_$i[] = {"
	xa $1.s -I$i
	od -w12 -t x1 a.o65 | sed -ne 's/ \(..\)/ 0x\1,/g;s/^[0-9]* /  /p'
	echo "};"
done

rm a.o65
