;;; @file rdfile.s
;;; Extension for reading files from 8-bit Commodores
;;; @author Marko Mkel (msmakela@nic.funet.fi)
;;; @author Olaf Seibert (seibert@mbfys.kun.nl)

;;; The protocol for reading a file is as follows.
;;; C=			other computer
;;;			<- <length>filename (<length> >= 80 quits)
;;;			<- 00 (filler byte for c2n232 on c64/c128)
;;; <length><chksum>datablock (255 bytes max) ->
;;;			<- ok (80 00) or repeat block (81 00) or stop (82 00)
;;; or
;;; <length=0><status (00=ok, nonzero=error)> ->

;;; Note that this code is binary patched before it is loaded to the computer.
;;; In sequences a9 xx a2 xx a0 xx, the 2nd and 3nd "xx" are replaced
;;; with the device number and the secondary address.

#include "ext.s"

	jsr prepare		; prepare for using the link
	jsr receive
	jmp loop1
loop	sei
	jsr receive_switch	; get file name length
loop1	SETNAM(filebuf)		; set the file name
	tax			; test length
	bpl noexit
	jmp exit		; negative length => reinstall server and exit.
noexit	beq nofnam

	stx fnamlen
	ldx #0			; receive file name
fnam	jsr receive		; preserves x but sets y to 0.
	sta filebuf,x
	inx
fnamlen = *+1
	cpx #0
	bcc fnam

	;; the patcher looks for lda#, ldx#, ldy# with identical constants
nofnam	lda #fileno
	ldx #fileno		; device number (self-modified)
	ldy #fileno		; secondary address (self-modified)
	SETLFS
	jsr close		; try to close the file first just in case
	clc
	lda #fileno
	jsr open		; now open the file
	READST			; test if the call to open succeeded
	beq rdfile

	;; abort the transfer and return to the main loop
abortst	tax
abortstx
	sei			; These are needed for the C2N232 cable, as
	ldy #5			; for some reason the Vic-20/C64/C128 KERNAL
	dey			; interferes with the cassette port.
	bne *-1
	jsr receive		; get the filler byte
	lda #0
	jsr send_switch		; send zero length
	txa
	jsr send		; send the ST value

	jsr clrchn
	lda #fileno
	jsr close

	lda #1			; for some reason the Vic-20/C64/C128 KERNAL
	bne loop		; branch always

rdfile	ldx #fileno		; go and select the file for reading
	jsr chkin
	READST
	bne abortst

	;; loop to send blocks from the file
nextblock
	ldx #0
	stx chksum		; clear checksum
	inx
	;; read up to 255 bytes from the file
rd	READST			; test ST for EOI on previous byte
	bne eof
	jsr chrin
	sta filebuf-1,x
	sec			; add into checksum
chksum = *+1
	adc #0			; placeholder for self-modifying code
	sta chksum
	inx			; x ranges from 01 to max FF
	bne rd

	READST			; test if we did indeed stop because of EOF
eof	and #$bf		; mask off bit 6 ($40), which indicates EOF
	beq noerr
	dex			; subtract last garbage byte
noerr	dex			; subtract the base offset
	beq abortstx
	stx blklen
	;; send the buffer contents to the other computer
sameblock
	sei
	jsr receive		; get the filler byte
	lda blklen
	jsr send_switch		; send length
	lda chksum
	jsr send		; send checksum
	ldx #0

snd	lda filebuf,x
	jsr send
	inx
blklen = *+1
	cpx #0			; placeholder for self-modifying code
	bne snd
	;; wait for go on, repeat, or abort.
	jsr receive_switch
#if pet
	cli
#endif
	cmp #$80
	beq nextblock
	cmp #$81
	beq sameblock
	;; $82 (or other values) abort with length=0 and status=0
	ldx #0
	beq abortstx		; branch always

filebuf				; 255 bytes of file data at end of code
