;;; @file track1541.s
;;; 1541 program for reading or writing disk tracks,
;;; adapted and optimized from pitchtrack v1.28.
;;; @author Marko Mkel (msmakela@nic.funet.fi)
;;; Original copyright message follows.

;----------------------------------------
; pitchtrack v1.28
; (c) Andreas "pitch" Andersson 1995-2002
;----------------------------------------
; This software is provided 'as-is', without any express
; or implied warranty. In no event will the author be
; held liable for any damages arising from the use of
; this software.
;
; Permission is granted to anyone to use this software
; for any purpose, including commercial applications,
; and to alter it and redistribute it freely, subject 
; to the following restrictions.
;
; 1. The origin of this software must not be misrepresented;
;    you must not claim that you wrote the original software.
;    If you use this software in a product, an acknowledgment
;    in the product documentation would be appreciated but
;    is not required.
; 2. Altered source versions must be plainly marked as such,
;    and must not be misrepresented as being the original
;    software.
; 3. This notice may not be removed or altered from any
;    source distribution.
;
; License adopted from zlib license at
; www.gzip.org/zlib/zlib_license.html

gcrbin		= $f8e0
bingcr		= $f78f
dstrt		= $f50a
chkblk		= $f5e9
srch		= $f510
sync		= $f556
cnvbin		= $f497
conhdr		= $f934
errr		= $f969
via2_porta	= $1c01
via2_ddra	= $1c03
pcr2		= $1c0c
buffer		= $0600
dtemp		= $6f
dtemp2		= $70
dtemp3		= $71
dtemp4		= $72
id1		= $12		; first ID byte
id2		= $13		; second ID byte
hdertrk		= $18		; track number in disk header
hdersect	= $19		; sector number in disk header
chksum		= $3a
bufpthi		= $31

; Drive program commands
CMD_READ	= 0
CMD_WRITE	= 1

; The code
*	=$300

	sei
;---------------------------------------
; Commands
;   0 - read track
;   1 - write track
; Everything else is interpreted as a termination command.
;---------------------------------------
	;; initialize the disk
	jsr clear2send
	lda #0
	sta 0			; clear the job code
	cli
	jsr $d042 ;Do init
cmdloop	sei
	lda #0
	jsr send
	jsr clear2recv
	sty $0b			; Y=0 => select sector 0
	jsr recv
	sta dtemp3
	cmp #CMD_WRITE + 1
	bcc rw
	;; end program
	cli
	rts

	;; read or write
rw	jsr recv		; get the track number
	sta $0a			; store it in the job queue
	sta hdertrk
	jsr clear2send
	lda #$e0
	cli
	sta $02			; execute job in buffer 2
job	lda $02			; wait for completion
	bmi job
	bpl cmdloop		; branch always

	;; Send a byte
send	sta dtemp4
	eor #$ff
	sta dtemp
	lda #0
	sta $1800
	nop
	ror dtemp
	rol
	asl
	ror dtemp
	rol
	asl
	sta $1800
	lda #0
	ror dtemp
	rol
	asl
	ror dtemp
	rol
	asl
	sta $1800
	lda #0
	ror dtemp
	rol
	asl
	ror dtemp
	rol
	asl
	sta $1800
	lda #0
	ror dtemp
	rol
	asl
	ror dtemp
	rol
	asl
	sta $1800
	jsr delay12
	nop
	nop
	nop
clear2send			; Prepare for sending data
	lda #$02
	sta $1800
	jsr delay12
	jsr delay12
	lda dtemp4
delay12	rts			; Delay for 12 cycles (jsr+rts)

	;; Prepare for receiving data
clear2recv
	ldy #0
	sty $1800
	jsr delay12
	rts

	;; Search for a particular header
mysrch	lda id2
	sta $17
	lda id1
	sta $16
	eor $17
	eor $18
	eor $19
	sta $1a
	jsr conhdr		; encode the header
	.(
compare	jsr sync
	ldy #$f8		; $100 - $8 = $f8
byte8	bvc *			; read 8 bytes
	clv
	lda via2_porta
	cmp $24+8,y
	bne compare		; mismatch; get another header
	iny
	bne byte8		; get all 8 bytes
	.)
	rts

	;; Receive a byte
recv	lda #%00000101
	.(
wait	bit $1800
	bne wait
	.)
	lda #0
	sta dtemp
	jsr delay12
	nop
	ldx #4
	.(
recv2	lda $1800		; Loop to receive 2 bits per iteration
	ror
	rol dtemp
	ror
	ror
	rol dtemp
	dex
	bne recv2
	.)
	lda dtemp
	rts

	;; Loop for reading sectors
readsectors
	jsr waitheader
	ldx #$f9		; $100 - 7 = $f9
	.(
read7	bvc *			; read 7 bytes
	clv
	lda via2_porta
	sta $25+7,x
	inx
	bne read7
	.)
	jsr cnvbin		; decode the header
	lda $16
	eor $17
	eor $18
	eor $19
	eor $1a
	bne readsectors		; checksum mismatch -> read another sector
	ldx dtemp2		; number of sectors on the track
	dex
	cpx hdersect
	bcc readsectors		; sector number out of range -> read another
	ldx hdersect
	inx			; increment the sector number
	cpx dtemp2		; (read next sector)
	.(
	bne nowrap:ldx #0	; wrap around the sector number
nowrap
	.)
	stx hdersect		; now really read this sector
	lda sectorsread,x
	bne readsectors		; the sector has been read -> read another
	inc sectorsread,x	; flag the sector read
	txa
	jsr send		; send the sector number
	jsr waitheader
	jsr sync
	.(
rdgcr1	bvc *			; read the first part of GCR data
	clv
	lda via2_porta
	sta buffer,y
	iny
	bne rdgcr1
	.)
	ldy #$ba
	.(
rdgcr2	bvc *			; read the second part of GCR data
	clv
	lda via2_porta
	sta $0100,y
	iny
	bne rdgcr2
	.)
	jsr gcrbin		; decode the GCR
	ldy #0			; send the sector
	.(
loop	lda buffer,y
	jsr send
	pha
	pla
	iny
	bne loop
	.)
	dec dtemp3
	bne readsectors		; loop until all sectors have been read
	;; finished reading the track
toggleled
	lda $1c00
	eor #8
	sta $1c00
	rts

	;; Wait for disk header
waitheader
	jsr sync
	bvc *			; wait for SO (Set Overflow) signal
	clv
	lda via2_porta
	cmp #$52
	bne waitheader
	rts

	;; Write a track
writetrack
wrloop	jsr send		; send last sector number
	jsr clear2recv		; Y=0
	jsr recv		; receive the next sector number
	sta hdersect
	eor #$ff		; $ff=done
	beq wrdone
	.(
loop	jsr recv		; receive the data for the sector
	sta buffer,y
	iny
	bne loop
	.)
	jsr clear2send
	jsr chkblk
	sta chksum
	lda $1c00
	and #$10
	beq wrerr
	jsr bingcr		; encode the sector
	jsr mysrch		; search for the sector header
	ldx #9
	.(
skip8	bvc *			; skip 8 bytes on the disk
	clv
	dex
	bne skip8
	.)
	dex
	stx via2_ddra		; X=$ff
	lda pcr2
	and #$1f
	ora #$c0
	sta pcr2
	lda #$ff
	ldx #5
	sta via2_porta
	clv
	.(
wsync	bvc *			; wait for the sync marks
	clv
	dex
	bne wsync
	.)
	ldy #$bb
	.(
wrgcr1	lda $0100,y		; get the first part of GCR encoded data
	bvc *
	clv
	sta via2_porta
	iny
	bne wrgcr1
	.)
	.(
wrgcr2	lda buffer,y		; get the second part of GCR encoded data
	bvc *
	clv
	sta via2_porta
	iny
	bne wrgcr2
	.)
	bvc *			; wait until the last byte has been written
	lda pcr2
	ora #$e0
	sta pcr2
	sty via2_ddra		; Y=0 upon exiting wrgcr2
	lda hdersect
	bpl wrloop		; branch always (sector numbers are <128)

wrerr	lda #8
	.byte $2c		; skip next instruction
wrdone	lda #1
	jmp errr

	;; Read track A
readtrack
	sta dtemp2
	sta dtemp3
	jsr send		; send the last sector number
	tax
	;; Clear the table of read sectors and read the track
	lda #0
	.(
clrrd	sta sectorsread,x
	dex
	bpl clrrd
	.)
	jsr readsectors
	lda #1
	jmp errr

	;; Code for buffer 2 (starts at $500)
	.dsb $500-*, $ff

	;; Read or write a track
	jsr toggleled
	lda #>buffer
	sta bufpthi
	lda $0a			; track number
	jsr $f24b		; get the number of sectors on the track
	ldy dtemp3
	beq readtrack
	jmp writetrack

sectorsread
;	ds.b 21
