/**
 * @file rdfile.h
 * Extension for reading files from the remote host
 * @author Marko Mkel (msmakela@nic.funet.fi)
 */

/*
 * Copyright  1994-1996 Marko Mkel and Olaf Seibert
 * Copyright  2001,2002 Marko Mkel
 * Original Linux and Commodore 64/128/Vic-20 version by Marko Mkel
 * Ported to the PET and the Amiga series by Olaf Seibert
 * Restructured by Marko Mkel
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/** install the rdfile extension
 * @param comm		the communication primitives
 * @param hostinfo	information on the remote host
 * @param device	device number
 * @param secondary	secondary address
 * @return		zero on success, nonzero on error
 */
int
rdfile_install (const struct comm* comm,
		const struct hostinfo* hostinfo,
		unsigned device,
		unsigned secondary);

/** remove the rdfile extension
 * @param comm		the communication primitives
 * @return		zero on success, nonzero on error
 */
int
rdfile_remove (const struct comm* comm);

/** display the disk directory
 * @param comm		the communication primitives
 * @param filename	file name search pattern (including drive unit number)
 * @param file		output file
 * @param buf		at least 256-byte transfer buffer
 * @return		zero on success, nonzero on error
 */
int
rdfile_directory (const struct comm* comm,
		  const char* filename,
		  FILE* file,
		  char* buf);

/** copy a file
 * @param comm		the communication primitives
 * @param filename	file name pattern (including drive unit number)
 * @param file		output file (0=none)
 * @param buf		at least 256-byte transfer buffer
 * @return		zero on success, nonzero on error
 */
int
rdfile (const struct comm* comm,
	const char* filename,
	FILE* file,
	char* buf);

/** copy a file
 * @param comm		the communication primitives
 * @param file		output file (0=none)
 * @param buf		(in) the file name, (out) at most 256 bytes of data
 * @return		zero on success, nonzero on error
 */
int
rdfile_raw (const struct comm* comm,
	    FILE* file,
	    char* buf);
